/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import io.opentelemetry.semconv.UserAgentAttributes;
import io.opentelemetry.semconv.incubating.DbIncubatingAttributes;
import io.opentelemetry.semconv.incubating.MessagingIncubatingAttributes;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class AttributesKeyCache {
    private static final Map<String, AttributeKey<String>> attributeKeyMap = new HashMap<String, AttributeKey<String>>();
    private final Object lock = new Object();

    private static void mapFields(Field[] declaredFields) {
        for (Field declaredField : declaredFields) {
            if (!declaredField.getType().isAssignableFrom(AttributeKey.class)) continue;
            try {
                AttributeKey key = (AttributeKey)declaredField.get(null);
                attributeKeyMap.put(key.toString(), (AttributeKey<String>)key);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeKey<String> getAttributeKey(String keyString) {
        AttributeKey key = attributeKeyMap.get(keyString);
        if (key == null) {
            key = AttributeKey.stringKey((String)keyString);
            Object object = this.lock;
            synchronized (object) {
                attributeKeyMap.put(keyString, (AttributeKey<String>)key);
            }
        }
        return key;
    }

    static {
        AttributesKeyCache.mapFields(HttpAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(UrlAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(UserAgentAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(ServerAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(DbIncubatingAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(MessagingIncubatingAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(SemanticAttributes.class.getDeclaredFields());
    }
}

