/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk;

import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.incubating.CloudIncubatingAttributes;

public class MuleCloudHubResource {
    private static Resource INSTANCE = MuleCloudHubResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    public static void refresh() {
        INSTANCE = MuleCloudHubResource.buildResource();
    }

    static Resource buildResource() {
        AttributesBuilder builder = Attributes.builder();
        builder.put(CloudIncubatingAttributes.CLOUD_PROVIDER, (Object)"mulesoft");
        if (PropertiesUtil.isCloudHubV1()) {
            OpenTelemetryUtil.addAttribute("application.aws.region", builder, (AttributeKey<String>)CloudIncubatingAttributes.CLOUD_REGION);
            builder.put(CloudIncubatingAttributes.CLOUD_PLATFORM, (Object)"mulesoft_cloudhub_v1");
            OpenTelemetryUtil.addAttribute("csorganization.id", builder, (AttributeKey<String>)CloudIncubatingAttributes.CLOUD_ACCOUNT_ID);
        } else if (PropertiesUtil.isCloudHubV2()) {
            builder.put(CloudIncubatingAttributes.CLOUD_PLATFORM, (Object)"mulesoft_cloudhub_v2");
            OpenTelemetryUtil.addAttribute("csorganization.id", builder, (AttributeKey<String>)CloudIncubatingAttributes.CLOUD_ACCOUNT_ID);
            OpenTelemetryUtil.addAttribute("ORG_ID", builder, (AttributeKey<String>)CloudIncubatingAttributes.CLOUD_ACCOUNT_ID);
        }
        return Resource.create((Attributes)builder.build());
    }

    private MuleCloudHubResource() {
    }
}

