/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.connection.TraceContextHandler;
import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import com.mulesoft.extension.mq.api.attributes.AnypointMQMessageAttributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.semconv.UrlAttributes;
import io.opentelemetry.semconv.incubating.MessagingIncubatingAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;

public class AnypointMQProcessorComponent
extends AbstractProcessorComponent {
    @Override
    protected String getNamespace() {
        return "anypoint-mq";
    }

    @Override
    protected List<String> getOperations() {
        return Arrays.asList("publish", "consume", "ack", "nack");
    }

    @Override
    protected List<String> getSources() {
        return Collections.singletonList("subscriber");
    }

    @Override
    protected SpanKind getSpanKind() {
        return SpanKind.PRODUCER;
    }

    @Override
    protected String getDefaultSpanName(Map<String, String> tags) {
        if (tags.containsKey(MessagingIncubatingAttributes.MESSAGING_DESTINATION_NAME.getKey())) {
            return this.formattedSpanName(tags.get(MessagingIncubatingAttributes.MESSAGING_DESTINATION_NAME.getKey()), "publish");
        }
        return super.getDefaultSpanName(tags);
    }

    private String formattedSpanName(String queueName, String operation) {
        return String.format("%s %s", queueName, operation);
    }

    @Override
    public TraceComponent getStartTraceComponent(Component component, Event event) {
        TraceComponent startTraceComponent = super.getStartTraceComponent(component, event);
        if ("consume".equalsIgnoreCase(startTraceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey()))) {
            startTraceComponent = startTraceComponent.withSpanKind(SpanKind.CONSUMER).withSpanName(this.formattedSpanName(startTraceComponent.getTags().get(MessagingIncubatingAttributes.MESSAGING_DESTINATION_NAME.getKey()), "receive"));
        }
        return startTraceComponent;
    }

    @Override
    protected <A> Map<String, String> getAttributes(Component component, TypedValue<A> attributes) {
        ComponentWrapper componentWrapper = new ComponentWrapper(component, this.configurationComponentLocator);
        Map<String, String> connectionParams = componentWrapper.getConfigConnectionParameters();
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(MessagingIncubatingAttributes.MESSAGING_CLIENT_ID.getKey(), connectionParams.get("clientId"));
        if (attributes != null && attributes.getValue() instanceof AnypointMQMessageAttributes) {
            AnypointMQMessageAttributes attrs = (AnypointMQMessageAttributes)attributes.getValue();
            tags.put(MessagingIncubatingAttributes.MESSAGING_MESSAGE_ID.getKey(), attrs.getMessageId());
        }
        tags.put(MessagingIncubatingAttributes.MESSAGING_SYSTEM.getKey(), "anypointmq");
        this.addTagIfPresent(componentWrapper.getParameters(), "destination", tags, MessagingIncubatingAttributes.MESSAGING_DESTINATION_NAME.getKey());
        this.addTagIfPresent(connectionParams, "url", tags, UrlAttributes.URL_FULL.getKey());
        return tags;
    }

    @Override
    public TraceComponent getSourceStartTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        TypedValue attributesTypedValue = notification.getEvent().getMessage().getAttributes();
        AnypointMQMessageAttributes attributes = (AnypointMQMessageAttributes)attributesTypedValue.getValue();
        Map<String, String> tags = this.getAttributes(this.getSourceComponent(notification).orElse(notification.getComponent()), attributesTypedValue);
        tags.put(MessagingIncubatingAttributes.MESSAGING_OPERATION_NAME.getKey(), "process");
        return TraceComponent.of(notification.getResourceIdentifier(), notification.getComponent().getLocation()).withTags(tags).withTransactionId(this.getTransactionId(notification)).withSpanName(this.formattedSpanName(attributes.getDestination(), "process")).withStatsCode(StatusCode.OK).withSpanKind(SpanKind.CONSUMER).withContext(traceContextHandler.getTraceContext(attributes.getProperties(), AbstractProcessorComponent.ContextMapGetter.INSTANCE));
    }

    @Override
    public TraceComponent getEndTraceComponent(EnrichedServerNotification notification) {
        return this.getTraceComponentBuilderFor(notification).withStatsCode(StatusCode.OK);
    }

    @Override
    public TraceComponent getSourceEndTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        return this.getTraceComponentBuilderFor(notification).withStatsCode(StatusCode.OK);
    }
}

