/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor.util;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import io.opentelemetry.semconv.HttpAttributes;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class HttpSpanUtil {
    public static String method(Map<String, String> tags) {
        String method = tags.get(HttpAttributes.HTTP_REQUEST_METHOD.getKey());
        Objects.requireNonNull(method, "HTTP Method must not be null");
        return method;
    }

    public static String spanName(Map<String, String> tags, String route) {
        return HttpSpanUtil.spanName(HttpSpanUtil.method(tags), route);
    }

    public static String spanName(String method, String route) {
        if (!PropertiesUtil.isUseAPIKitSpanNames()) {
            return route;
        }
        return method.toUpperCase(Locale.ROOT) + " " + route;
    }

    public static String apiKitRoutePath(Map<String, String> tags) {
        String flowName = tags.get(SemanticAttributes.MULE_APP_FLOW_NAME.getKey());
        Objects.requireNonNull(flowName, "Flow name must not be null");
        return flowName.split(":")[1].replace(":", "").replaceAll("\\\\", "/").replaceAll("\\(", "{").replaceAll("\\)", "}");
    }
}

