/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.notifications.listeners;

import com.avioconsulting.mule.opentelemetry.internal.notifications.listeners.AbstractMuleNotificationListener;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import org.mule.runtime.api.notification.AsyncMessageNotification;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncMessageNotificationListener
extends AbstractMuleNotificationListener
implements org.mule.runtime.api.notification.AsyncMessageNotificationListener<AsyncMessageNotification> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncMessageNotificationListener.class);

    public AsyncMessageNotificationListener(MuleNotificationProcessor muleNotificationProcessor) {
        super(muleNotificationProcessor);
    }

    public void onNotification(AsyncMessageNotification notification) {
        this.replaceMDCEntry(notification.getEvent());
        LOGGER.trace("===> Received {}:{}", (Object)notification.getClass().getName(), (Object)notification.getActionName());
        switch (Integer.parseInt(notification.getAction().getIdentifier())) {
            case 1901: {
                LOGGER.trace("Scheduled {}:{} - {}", new Object[]{notification.getEventName(), notification.getComponent().getIdentifier().getName(), notification.getEvent().getContext().getId()});
                this.muleNotificationProcessor.handleAsyncScheduledEvent(notification);
                break;
            }
            case 1902: {
                LOGGER.trace("Completed {} - {}", (Object)notification.getEventName(), (Object)notification.getEvent().getContext().getId());
                this.muleNotificationProcessor.handleProcessorEndEvent((EnrichedServerNotification)notification);
            }
        }
    }
}

