/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.traces.ComponentEventContext;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.HttpSpanUtil;
import com.avioconsulting.mule.opentelemetry.internal.store.ProcessorSpan;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.semconv.HttpAttributes;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowSpan
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowSpan.class);
    private final String flowName;
    private String rootSpanName;
    private final Span span;
    private final String transactionId;
    private final Map<String, ProcessorSpan> childSpans = new ConcurrentHashMap<String, ProcessorSpan>();
    private Map<String, String> tags = new HashMap<String, String>();
    private String apikitConfigName;
    private final AtomicInteger childFlowCounter = new AtomicInteger();

    public FlowSpan(String flowName, Span span, String transactionId) {
        this.flowName = flowName;
        this.span = span;
        this.transactionId = transactionId;
    }

    public Span getSpan() {
        return this.span;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getApikitConfigName() {
        return this.apikitConfigName;
    }

    public SpanMeta addProcessorSpan(String containerName, TraceComponent traceComponent, SpanBuilder spanBuilder) {
        ProcessorSpan ps;
        LOGGER.trace("Adding Span at location {} for flow {} trace transaction {} context {}", new Object[]{traceComponent.contextScopedLocation(), this.getRootSpanName(), this.transactionId, this.getSpan().getSpanContext().toString()});
        if (containerName != null) {
            if (this.getFlowName().equals(containerName)) {
                spanBuilder.setParent(this.getSpan().storeInContext(Context.current()));
            } else {
                String contextScopedContainer = traceComponent.contextScopedPath(containerName);
                ps = new ProcessorSpan(this.getSpan(), traceComponent.getLocation(), this.transactionId, traceComponent.getStartTime(), this.flowName).setTags(this.getTags());
                ProcessorSpan parentSpan = this.getParentSpan(traceComponent, containerName);
                if (parentSpan == null) {
                    LOGGER.debug("Parent span not found for {}. Child span keys - {}", (Object)contextScopedContainer, this.childSpans.keySet());
                    parentSpan = ps;
                }
                LOGGER.debug("Parent span existence check for {} at {}", (Object)traceComponent.getLocation(), (Object)parentSpan.getLocation());
                spanBuilder.setParent(parentSpan.getContext());
            }
        }
        this.extractAPIKitConfigName(traceComponent);
        this.resetSpanNameIfNeeded(traceComponent);
        Span span = spanBuilder.startSpan();
        ps = new ProcessorSpan(span, traceComponent.getLocation(), this.transactionId, traceComponent.getStartTime(), this.flowName).setTags(traceComponent.getTags());
        LOGGER.trace("Adding span for {}:{} - {}", new Object[]{traceComponent.contextScopedLocation(), traceComponent.getSpanName(), span.getSpanContext().getSpanId()});
        this.childSpans.putIfAbsent(traceComponent.contextScopedLocation(), ps);
        return ps;
    }

    public void addChildFlow(TraceComponent traceComponent, SpanBuilder spanBuilder) {
        this.addProcessorSpan(null, traceComponent, spanBuilder);
        this.childFlowCounter.incrementAndGet();
    }

    public ProcessorSpan endChildFlow(TraceComponent traceComponent, Consumer<Span> endSpan) {
        ProcessorSpan processorSpan = this.findSpan(traceComponent.contextScopedPath(traceComponent.getName()));
        if (processorSpan == null) {
            LOGGER.trace("Attempting to find in parent scopes for {} in list {}", (Object)traceComponent, this.childSpans);
            processorSpan = this.getParentSpan(traceComponent, traceComponent.getName());
        }
        if (processorSpan != null) {
            endSpan.accept(processorSpan.getSpan());
            processorSpan.setEndTime(traceComponent.getEndTime());
            this.childFlowCounter.decrementAndGet();
            LOGGER.trace("Ended a span of a flow {} invoked with flow-ref for transaction {} ", (Object)traceComponent.getName(), (Object)traceComponent.getTransactionId());
        } else {
            LOGGER.trace("No Processor span found for {} ", (Object)traceComponent);
        }
        return processorSpan;
    }

    private ProcessorSpan getParentSpan(ComponentEventContext context, String container) {
        for (int i = 0; i < context.contextNestingLevel(); ++i) {
            ProcessorSpan processorSpan = this.childSpans.get(context.contextCopedPath(container, i));
            if (processorSpan == null) continue;
            return processorSpan;
        }
        return null;
    }

    private void resetSpanNameIfNeeded(TraceComponent traceComponent) {
        if (!PropertiesUtil.isUseAPIKitSpanNames()) {
            return;
        }
        if (this.apikitConfigName != null && ComponentsUtil.isFlowTrace(traceComponent) && traceComponent.getName().endsWith(":" + this.apikitConfigName) && this.rootSpanName.endsWith("/*")) {
            String apiKitRoutePath = HttpSpanUtil.apiKitRoutePath(traceComponent.getTags());
            String spanName = this.getRootSpanName().replace("/*", apiKitRoutePath);
            this.setRootSpanName(spanName);
            this.getSpan().updateName(spanName);
            String httpRoute = spanName.substring(spanName.lastIndexOf(" ") + 1);
            this.getTags().put(HttpAttributes.HTTP_ROUTE.getKey(), httpRoute);
            this.getSpan().setAttribute(HttpAttributes.HTTP_ROUTE, (Object)httpRoute);
        }
    }

    private void extractAPIKitConfigName(TraceComponent traceComponent) {
        if (this.apikitConfigName == null && "apikit".equals(traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_NAMESPACE.getKey())) && "router".equals(traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey()))) {
            this.apikitConfigName = traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_CONFIG_REF.getKey());
        }
    }

    public SpanMeta endProcessorSpan(TraceComponent traceComponent, Consumer<Span> spanUpdater, Instant endTime) {
        LOGGER.trace("Ending Span at location {} for flow {} trace transaction {} context {}", new Object[]{traceComponent.contextScopedLocation(), this.getRootSpanName(), this.transactionId, this.getSpan().getSpanContext().toString()});
        if (this.childSpans.containsKey(traceComponent.contextScopedLocation())) {
            ProcessorSpan removed = Objects.requireNonNull(this.childSpans.remove(traceComponent.contextScopedLocation()), "Missing child span at location " + traceComponent.contextScopedLocation() + " for flow " + this.getRootSpanName() + " trace transaction " + this.transactionId + " context " + this.getSpan().getSpanContext().toString());
            LOGGER.trace("Removing span for {} - {}", (Object)traceComponent.contextScopedLocation(), (Object)removed.getSpanId());
            this.endRouteSpans(traceComponent, endTime);
            removed.setEndTime(endTime);
            if (spanUpdater != null) {
                spanUpdater.accept(removed.getSpan());
            }
            removed.getSpan().end(endTime);
            return removed;
        }
        return null;
    }

    private void endRouteSpans(TraceComponent traceComponent, Instant endTime) {
        if (!TypedComponentIdentifier.ComponentType.ROUTER.equals((Object)traceComponent.getComponentLocation().getComponentIdentifier().getType())) {
            return;
        }
        String regexPattern = String.format("^%s(_\\d.*)?\\/%s\\/route\\/\\d*$", traceComponent.getEventContextId(), Pattern.quote(traceComponent.getLocation()));
        Pattern pattern = Pattern.compile(regexPattern);
        Predicate<String> predicate = pattern.asPredicate();
        this.childSpans.keySet().stream().filter(predicate).forEach(k -> {
            ProcessorSpan removed = this.childSpans.remove(k);
            if (removed != null) {
                LOGGER.trace("Ending Route Span at location {} for flow {} trace transaction {} context {}", new Object[]{k, this.getRootSpanName(), this.transactionId, removed.getSpan().getSpanContext()});
                removed.getSpan().end(endTime);
            }
        });
    }

    public ProcessorSpan findSpan(String location) {
        ProcessorSpan processorSpan = this.childSpans.get(location);
        if (processorSpan == null) {
            LOGGER.trace("Could not find span for location {}  in the list {}", (Object)location, this.childSpans);
        }
        return processorSpan;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public FlowSpan setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String getRootSpanName() {
        return this.rootSpanName;
    }

    public FlowSpan setRootSpanName(String rootSpanName) {
        this.rootSpanName = rootSpanName;
        return this;
    }

    public boolean childFlowsEnded() {
        return this.childFlowCounter.get() <= 0;
    }
}

