/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.connection;

import com.avioconsulting.mule.opentelemetry.api.AppIdentifier;
import com.avioconsulting.mule.opentelemetry.api.providers.OpenTelemetryMetricsConfigProvider;
import com.avioconsulting.mule.opentelemetry.api.providers.OpenTelemetryMetricsProvider;
import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionStore;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.api.traces.TransactionContext;
import com.avioconsulting.mule.opentelemetry.internal.config.OpenTelemetryConfigWrapper;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryMetricsProviderCollection;
import com.avioconsulting.mule.opentelemetry.internal.connection.TraceContextHandler;
import com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk.AttributesKeyCache;
import com.avioconsulting.mule.opentelemetry.internal.store.InMemoryTransactionStore;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.ServiceProviderUtil;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryConnection
implements TraceContextHandler {
    public static final String TRACE_ID_LONG_LOW_PART = "traceIdLongLowPart";
    public static final String SPAN_ID_LONG = "spanIdLong";
    private final OpenTelemetryMetricsProviderCollection metricsProviders = ServiceProviderUtil.load(OpenTelemetryMetricsProvider.class.getClassLoader(), OpenTelemetryMetricsProvider.class, new OpenTelemetryMetricsProviderCollection());
    private final Logger logger = LoggerFactory.getLogger(OpenTelemetryConnection.class);
    private OpenTelemetryMetricsConfigProvider metricsProvider;
    private AppIdentifier appIdentifier;
    private ExpressionManager expressionManager;
    private final AttributesKeyCache attributesKeyCache = new AttributesKeyCache();
    private static final String INSTRUMENTATION_VERSION = "0.0.1-DEV";
    public final Map<String, String> OTEL_SYSTEM_PROPERTIES_MAP = System.getProperties().stringPropertyNames().stream().filter(p -> p.contains(".otel.")).collect(Collectors.toMap(String::toLowerCase, System::getProperty));
    private static final String INSTRUMENTATION_NAME = "mule-opentelemetry-module-DEV";
    private final TransactionStore transactionStore;
    private OpenTelemetryConnection openTelemetryConnection;
    private OpenTelemetry openTelemetry;
    private final Tracer tracer;
    private boolean turnOffTracing = false;
    private boolean turnOffMetrics = false;
    private final Object lock = new Object();

    private OpenTelemetryConnection(OpenTelemetryConfigWrapper openTelemetryConfigWrapper) {
        Properties properties = OpenTelemetryConnection.getModuleProperties();
        String instrumentationVersion = properties.getProperty("module.version", INSTRUMENTATION_VERSION);
        String instrumentationName = properties.getProperty("module.artifactId", INSTRUMENTATION_NAME);
        this.logger.info("Initialising OpenTelemetry Mule 4 Agent for instrumentation {}:{}", (Object)instrumentationName, (Object)instrumentationVersion);
        AutoConfiguredOpenTelemetrySdkBuilder builder = AutoConfiguredOpenTelemetrySdk.builder();
        if (openTelemetryConfigWrapper != null) {
            HashMap<String, String> configMap = new HashMap<String, String>();
            if (openTelemetryConfigWrapper.getResource() != null) {
                configMap.putAll(openTelemetryConfigWrapper.getResource().getConfigMap());
            }
            if (openTelemetryConfigWrapper.getExporter() != null) {
                configMap.putAll(openTelemetryConfigWrapper.getExporter().getExporterProperties());
            }
            if (openTelemetryConfigWrapper.getSpanProcessorConfiguration() != null) {
                configMap.putAll(openTelemetryConfigWrapper.getSpanProcessorConfiguration().getConfigMap());
            }
            configMap.put("otel.java.disabled.resource.providers", "io.opentelemetry.instrumentation.resources.HostResourceProvider,io.opentelemetry.instrumentation.resources.ContainerResourceProvider");
            builder.addPropertiesSupplier(() -> Collections.unmodifiableMap(configMap));
            this.logger.debug("Creating OpenTelemetryConnection with properties: [{}]", configMap);
            this.turnOffTracing = openTelemetryConfigWrapper.isTurnOffTracing();
            this.turnOffMetrics = openTelemetryConfigWrapper.isTurnOffMetrics();
            this.appIdentifier = openTelemetryConfigWrapper.getOpenTelemetryConfiguration().getAppIdentifier();
            this.metricsProvider = openTelemetryConfigWrapper.getOpenTelemetryConfiguration().getMetricsConfigProvider();
            this.expressionManager = openTelemetryConfigWrapper.getOpenTelemetryConfiguration().getExpressionManager();
        }
        builder.setServiceClassLoader(AutoConfiguredOpenTelemetrySdkBuilder.class.getClassLoader());
        if (!this.turnOffMetrics) {
            this.metricsProvider.initialise(this.appIdentifier);
        }
        this.openTelemetry = builder.build().getOpenTelemetrySdk();
        this.installOpenTelemetryLogger();
        if (!this.turnOffMetrics) {
            this.logger.info("Initializing Metrics Providers");
            this.metricsProvider.start();
            this.metricsProviders.initialize(this.metricsProvider, this.openTelemetry);
        } else {
            this.logger.info("Disabling loaded Metrics Providers");
            this.metricsProviders.clear();
        }
        this.tracer = this.openTelemetry.getTracer(instrumentationName, instrumentationVersion);
        this.transactionStore = InMemoryTransactionStore.getInstance();
        PropertiesUtil.init();
        this.openTelemetryConnection = this;
    }

    public void withOpenTelemetry(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    private void installOpenTelemetryLogger() {
        try {
            Class<?> clazz = Class.forName("com.avioconsulting.mule.opentelemetry.logs.api.OpenTelemetryLog4jAppender");
            Method install = clazz.getMethod("install", OpenTelemetry.class);
            this.logger.info("Initializing AVIO OpenTelemetry Log4J support");
            install.invoke(null, this.openTelemetry);
        }
        catch (ClassNotFoundException e) {
            this.logger.warn("OpenTelemetry Log4j support not found on the classpath. Logs will not be exported via OpenTelemetry.");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public AppIdentifier getAppIdentifier() {
        return this.appIdentifier;
    }

    public boolean isTurnOffTracing() {
        return this.turnOffTracing;
    }

    public boolean isTurnOffMetrics() {
        return this.turnOffMetrics;
    }

    public OpenTelemetryMetricsProviderCollection getMetricsProviders() {
        return this.metricsProviders;
    }

    public static void resetForTest() {
    }

    public static synchronized OpenTelemetryConnection getInstance(OpenTelemetryConfigWrapper openTelemetryConfigWrapper) {
        return new OpenTelemetryConnection(openTelemetryConfigWrapper);
    }

    private static Properties getModuleProperties() {
        Properties moduleProperties = new Properties();
        try {
            InputStream resourceAsStream = OpenTelemetryConnection.class.getClassLoader().getResourceAsStream("mule-opentelemetry-module.properties");
            if (resourceAsStream != null) {
                moduleProperties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return moduleProperties;
    }

    public SpanBuilder spanBuilder(String spanName) {
        return this.tracer.spanBuilder(spanName);
    }

    @Override
    public <T> Context getTraceContext(T carrier, TextMapGetter<T> textMapGetter) {
        return this.openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), carrier, textMapGetter);
    }

    public Map<String, String> getTraceContext(String transactionId) {
        return this.getTraceContext(transactionId, (String)null);
    }

    public Map<String, String> getTraceContext(String transactionId, String componentLocation) {
        TransactionContext transactionContext = this.getTransactionStore().getTransactionContext(transactionId, componentLocation);
        HashMap<String, String> traceContext = new HashMap<String, String>(10);
        traceContext.put("TRACE_TRANSACTION_ID", transactionId);
        traceContext.put("traceId", transactionContext.getTraceId());
        traceContext.put(TRACE_ID_LONG_LOW_PART, transactionContext.getTraceIdLongLowPart());
        traceContext.put("spanId", transactionContext.getSpanId());
        traceContext.put(SPAN_ID_LONG, transactionContext.getSpanIdLong());
        this.injectTraceContext(transactionContext.getContext(), traceContext, HashMapTextMapSetter.INSTANCE);
        this.logger.debug("Created trace context '{}' for TRACE_TRANSACTION_ID={}, Component Location '{}'", new Object[]{traceContext, transactionId, componentLocation});
        return traceContext;
    }

    @Override
    public <T> void injectTraceContext(T carrier, TextMapSetter<T> textMapSetter) {
        this.openTelemetry.getPropagators().getTextMapPropagator().inject(Context.current(), carrier, textMapSetter);
    }

    private <T> void injectTraceContext(Context context, T carrier, TextMapSetter<T> textMapSetter) {
        this.openTelemetry.getPropagators().getTextMapPropagator().inject(context, carrier, textMapSetter);
    }

    public TransactionStore getTransactionStore() {
        return this.transactionStore;
    }

    public void invalidate() {
    }

    public Meter get(String instrumentationScopeName) {
        return this.openTelemetry.meterBuilder(instrumentationScopeName).build();
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void addProcessorSpan(TraceComponent traceComponent, String containerName) {
        SpanBuilder spanBuilder = this.spanBuilder(traceComponent.getSpanName()).setSpanKind(traceComponent.getSpanKind()).setStartTimestamp(traceComponent.getStartTime());
        OpenTelemetryUtil.addGlobalConfigSystemAttributes(traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_CONFIG_REF.getKey()), traceComponent.getTags(), this.OTEL_SYSTEM_PROPERTIES_MAP);
        traceComponent.getTags().forEach((k, v) -> spanBuilder.setAttribute(this.attributesKeyCache.getAttributeKey((String)k), v));
        String parentLocation = ComponentsUtil.getRouteContainerLocation(traceComponent);
        if (parentLocation != null) {
            TraceComponent parentTrace = TraceComponent.of(parentLocation).withLocation(parentLocation).withTags(Collections.emptyMap()).withTransactionId(traceComponent.getTransactionId()).withSpanName(parentLocation).withSpanKind(SpanKind.INTERNAL).withEventContextId(traceComponent.getEventContextId()).withStartTime(traceComponent.getStartTime());
            SpanMeta parentSpan = this.addRouteSpan(parentTrace, traceComponent, parentLocation, ComponentsUtil.getLocationParent(parentLocation));
            spanBuilder.setParent(parentSpan.getContext());
        }
        if (parentLocation == null) {
            parentLocation = containerName;
        }
        this.getTransactionStore().addProcessorSpan(parentLocation, traceComponent, spanBuilder);
    }

    private SpanMeta addRouteSpan(TraceComponent parentTrace, TraceComponent childTrace, String parentLocation, String rootContainerName) {
        SpanBuilder spanBuilder = this.spanBuilder(parentLocation).setParent(childTrace.getContext()).setSpanKind(SpanKind.INTERNAL).setStartTimestamp(childTrace.getStartTime());
        return this.getTransactionStore().addProcessorSpan(rootContainerName, parentTrace, spanBuilder);
    }

    public SpanMeta endProcessorSpan(TraceComponent traceComponent, Error error) {
        return this.getTransactionStore().endProcessorSpan(traceComponent.getTransactionId(), traceComponent, span -> {
            if (error != null) {
                span.recordException(error.getCause());
            }
            this.setSpanStatus(traceComponent, (Span)span);
            if (traceComponent.getTags() != null) {
                traceComponent.getTags().forEach((k, v) -> span.setAttribute(this.attributesKeyCache.getAttributeKey((String)k), v));
            }
        }, traceComponent.getEndTime());
    }

    public void startTransaction(TraceComponent traceComponent) {
        SpanBuilder spanBuilder = this.openTelemetryConnection.spanBuilder(traceComponent.getSpanName()).setSpanKind(traceComponent.getSpanKind()).setParent(traceComponent.getContext()).setStartTimestamp(traceComponent.getStartTime());
        OpenTelemetryUtil.addGlobalConfigSystemAttributes(traceComponent.getTags().get(SemanticAttributes.MULE_APP_FLOW_SOURCE_CONFIG_REF.getKey()), traceComponent.getTags(), this.openTelemetryConnection.OTEL_SYSTEM_PROPERTIES_MAP);
        traceComponent.getTags().forEach((k, v) -> spanBuilder.setAttribute(this.attributesKeyCache.getAttributeKey((String)k), v));
        this.getTransactionStore().startTransaction(traceComponent, traceComponent.getName(), spanBuilder);
    }

    public TransactionMeta endTransaction(TraceComponent traceComponent, Exception exception) {
        if (traceComponent == null) {
            return null;
        }
        return this.openTelemetryConnection.getTransactionStore().endTransaction(traceComponent, (Span rootSpan) -> {
            traceComponent.getTags().forEach((k, v) -> rootSpan.setAttribute(this.attributesKeyCache.getAttributeKey((String)k), v));
            this.openTelemetryConnection.setSpanStatus(traceComponent, (Span)rootSpan);
            if (exception != null) {
                rootSpan.recordException((Throwable)exception);
                rootSpan.setAttribute(SemanticAttributes.ERROR_TYPE.getKey(), exception.getClass().getTypeName());
            }
        });
    }

    public void setSpanStatus(TraceComponent traceComponent, Span span) {
        if (traceComponent.getStatusCode() != null && !StatusCode.UNSET.equals((Object)traceComponent.getStatusCode())) {
            span.setStatus(traceComponent.getStatusCode(), traceComponent.getErrorMessage());
        }
    }

    public static enum HashMapTextMapSetter implements TextMapSetter<Map<String, String>>
    {
        INSTANCE;


        public void set(@Nullable Map<String, String> carrier, String key, String value) {
            if (carrier != null) {
                carrier.put(key, value);
            }
        }
    }
}

