/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.config;

import com.avioconsulting.mule.opentelemetry.api.AppIdentifier;
import com.avioconsulting.mule.opentelemetry.api.config.ExporterConfiguration;
import com.avioconsulting.mule.opentelemetry.api.config.OpenTelemetryResource;
import com.avioconsulting.mule.opentelemetry.api.config.SpanProcessorConfiguration;
import com.avioconsulting.mule.opentelemetry.api.config.TraceLevelConfiguration;
import com.avioconsulting.mule.opentelemetry.api.notifications.MetricBaseNotificationData;
import com.avioconsulting.mule.opentelemetry.api.providers.NoopOpenTelemetryMetricsConfigProvider;
import com.avioconsulting.mule.opentelemetry.api.providers.OpenTelemetryMetricsConfigProvider;
import com.avioconsulting.mule.opentelemetry.api.providers.OpenTelemetryMetricsConfigSupplier;
import com.avioconsulting.mule.opentelemetry.internal.OpenTelemetryOperations;
import com.avioconsulting.mule.opentelemetry.internal.config.OpenTelemetryConfigWrapper;
import com.avioconsulting.mule.opentelemetry.internal.config.OpenTelemetryConfiguration;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import com.avioconsulting.mule.opentelemetry.internal.notifications.listeners.AsyncMessageNotificationListener;
import com.avioconsulting.mule.opentelemetry.internal.notifications.listeners.MetricEventNotificationListener;
import com.avioconsulting.mule.opentelemetry.internal.notifications.listeners.MuleMessageProcessorNotificationListener;
import com.avioconsulting.mule.opentelemetry.internal.notifications.listeners.MulePipelineMessageNotificationListener;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={OpenTelemetryOperations.class})
@Configuration
public class OpenTelemetryExtensionConfiguration
implements Startable,
Stoppable,
OpenTelemetryConfiguration,
OpenTelemetryMetricsConfigSupplier {
    public static final String PROP_MULE_OTEL_METRICS_DISABLED = "mule.otel.metrics.disabled";
    public static final String PROP_MULE_OTEL_TRACING_DISABLED = "mule.otel.tracing.disabled";
    private final Logger logger = LoggerFactory.getLogger(OpenTelemetryExtensionConfiguration.class);
    private static final DataType METRIC_NOTIFICATION_DATA_TYPE = DataType.fromType(MetricBaseNotificationData.class);
    @RefName
    private String configName;
    @Inject
    private HttpService httpService;
    @Inject
    private ExpressionManager expressionManager;
    private AppIdentifier appIdentifier;
    private OpenTelemetryConnection openTelemetryConnection;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="Turn off tracing for this application.")
    private boolean turnOffTracing;
    @ParameterGroup(name="Resource")
    @Placement(order=10)
    @Summary(value="Open Telemetry Resource Configuration. System or Environment Variables will override this configuration.")
    private OpenTelemetryResource resource;
    @ParameterGroup(name="Exporter")
    @Placement(order=20)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private ExporterConfiguration exporterConfiguration;
    @ParameterGroup(name="Trace Levels")
    @Placement(order=30)
    private TraceLevelConfiguration traceLevelConfiguration;
    @ParameterGroup(name="Span Processor")
    @Placement(order=40, tab="Tracer Settings")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private SpanProcessorConfiguration spanProcessorConfiguration;
    @Parameter
    @Optional(defaultValue="false")
    @Placement(order=501, tab="Metrics")
    @Summary(value="Turn off Metrics for this application.")
    private boolean turnOffMetrics;
    @Parameter
    @Optional
    @Placement(order=502, tab="Metrics")
    @DisplayName(value="Metrics Provider")
    @Summary(value="OpenTelemetry Metrics Provider")
    private OpenTelemetryMetricsConfigProvider metricsConfigProvider;
    @Inject
    NotificationListenerRegistry notificationListenerRegistry;
    @Inject
    MuleNotificationProcessor muleNotificationProcessor;

    @Override
    public HttpService getHttpService() {
        return this.httpService;
    }

    @Override
    public boolean isTurnOffTracing() {
        return System.getProperties().containsKey(PROP_MULE_OTEL_TRACING_DISABLED) ? Boolean.parseBoolean(System.getProperty(PROP_MULE_OTEL_TRACING_DISABLED)) : this.turnOffTracing;
    }

    @Override
    public boolean isTurnOffMetrics() {
        boolean disabled;
        boolean bl = disabled = System.getProperties().containsKey(PROP_MULE_OTEL_METRICS_DISABLED) ? Boolean.parseBoolean(System.getProperty(PROP_MULE_OTEL_METRICS_DISABLED)) : this.turnOffMetrics;
        if (!disabled) {
            disabled = this.metricsConfigProvider == null || this.metricsConfigProvider instanceof NoopOpenTelemetryMetricsConfigProvider;
        }
        return disabled;
    }

    OpenTelemetryExtensionConfiguration setTurnOffTracing(boolean turnOffTracing) {
        this.turnOffTracing = turnOffTracing;
        return this;
    }

    @Override
    public OpenTelemetryResource getResource() {
        return this.resource;
    }

    public OpenTelemetryExtensionConfiguration setResource(OpenTelemetryResource resource) {
        this.resource = resource;
        return this;
    }

    @Override
    public ExporterConfiguration getExporterConfiguration() {
        return this.exporterConfiguration;
    }

    public OpenTelemetryExtensionConfiguration setExporterConfiguration(ExporterConfiguration exporterConfiguration) {
        this.exporterConfiguration = exporterConfiguration;
        return this;
    }

    @Override
    public TraceLevelConfiguration getTraceLevelConfiguration() {
        return this.traceLevelConfiguration;
    }

    public OpenTelemetryExtensionConfiguration setTraceLevelConfiguration(TraceLevelConfiguration traceLevelConfiguration) {
        this.traceLevelConfiguration = traceLevelConfiguration;
        return this;
    }

    @Override
    public SpanProcessorConfiguration getSpanProcessorConfiguration() {
        return this.spanProcessorConfiguration;
    }

    public OpenTelemetryExtensionConfiguration setSpanProcessorConfiguration(SpanProcessorConfiguration spanProcessorConfiguration) {
        this.spanProcessorConfiguration = spanProcessorConfiguration;
        return this;
    }

    @Override
    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public OpenTelemetryConnection getOpenTelemetryConnection() {
        return this.openTelemetryConnection;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    public void start() throws MuleException {
        this.logger.info("Initiating otel config - '{}'", (Object)this.getConfigName());
        this.appIdentifier = AppIdentifier.fromEnvironment(this.expressionManager);
        this.openTelemetryConnection = OpenTelemetryConnection.getInstance(new OpenTelemetryConfigWrapper(this));
        this.getTraceLevelConfiguration().initMuleComponentsMap();
        this.muleNotificationProcessor.init(this.openTelemetryConnection, this.getTraceLevelConfiguration());
        if (this.isTurnOffTracing()) {
            this.logger.info("Tracing has been turned off. No listener will be registered.");
        } else {
            this.notificationListenerRegistry.registerListener((NotificationListener)new MuleMessageProcessorNotificationListener(this.muleNotificationProcessor));
            this.notificationListenerRegistry.registerListener((NotificationListener)new MulePipelineMessageNotificationListener(this.muleNotificationProcessor));
            this.notificationListenerRegistry.registerListener((NotificationListener)new AsyncMessageNotificationListener(this.muleNotificationProcessor));
        }
        if (this.isTurnOffMetrics()) {
            this.logger.info("Metrics has been turned off. No listener will be registered.");
        } else {
            this.notificationListenerRegistry.registerListener((NotificationListener)new MetricEventNotificationListener(this.muleNotificationProcessor), extensionNotification -> METRIC_NOTIFICATION_DATA_TYPE.isCompatibleWith(extensionNotification.getData().getDataType()));
        }
    }

    @Override
    public AppIdentifier getAppIdentifier() {
        return this.appIdentifier;
    }

    @Override
    public OpenTelemetryMetricsConfigProvider getMetricsConfigProvider() {
        return this.metricsConfigProvider;
    }

    public void stop() throws MuleException {
    }
}

