/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.config.TraceLevelConfiguration;
import com.avioconsulting.mule.opentelemetry.api.processor.ProcessorComponent;
import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionMeta;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import com.avioconsulting.mule.opentelemetry.internal.interceptor.InterceptorProcessorConfig;
import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.FlowProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.GenericProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ProcessorComponentService;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.AsyncMessageNotification;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleNotificationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MuleNotificationProcessor.class);
    public static final String MULE_OTEL_SPAN_PROCESSORS_ENABLE_PROPERTY_NAME = "mule.otel.span.processors.enable";
    public static final List<String> CONTEXT_EXPRESSIONS = Arrays.asList("#[attributes.headers]", "#[attributes.properties]", "#[attributes.properties.userProperties]", "#[payload.message.messageAttributes]");
    private Supplier<OpenTelemetryConnection> connectionSupplier;
    private boolean spanAllProcessors;
    private TraceLevelConfiguration traceLevelConfiguration;
    private OpenTelemetryConnection openTelemetryConnection;
    ConfigurationComponentLocator configurationComponentLocator;
    private ProcessorComponentService processorComponentService;
    private final ProcessorComponent flowProcessorComponent;
    private final InterceptorProcessorConfig interceptorProcessorConfig = new InterceptorProcessorConfig();
    private final ConcurrentHashMap<String, String> flowContextExpressions = new ConcurrentHashMap();
    private final ProcessorComponent genericProcessorComponent;

    @Inject
    public MuleNotificationProcessor(ConfigurationComponentLocator configurationComponentLocator) {
        this.configurationComponentLocator = configurationComponentLocator;
        this.flowProcessorComponent = new FlowProcessorComponent().withConfigurationComponentLocator(configurationComponentLocator);
        this.genericProcessorComponent = new GenericProcessorComponent().withConfigurationComponentLocator(configurationComponentLocator);
    }

    public InterceptorProcessorConfig getInterceptorProcessorConfig() {
        return this.interceptorProcessorConfig;
    }

    public boolean hasConnection() {
        return this.openTelemetryConnection != null;
    }

    public OpenTelemetryConnection getOpenTelemetryConnection() {
        return this.openTelemetryConnection;
    }

    public Supplier<OpenTelemetryConnection> getConnectionSupplier() {
        return this.connectionSupplier;
    }

    public void init(OpenTelemetryConnection connection, TraceLevelConfiguration traceLevelConfiguration) {
        this.openTelemetryConnection = connection;
        this.spanAllProcessors = Boolean.parseBoolean(System.getProperty(MULE_OTEL_SPAN_PROCESSORS_ENABLE_PROPERTY_NAME, Boolean.toString(traceLevelConfiguration.isSpanAllProcessors())));
        this.traceLevelConfiguration = traceLevelConfiguration;
        this.interceptorProcessorConfig.setTurnOffTracing(this.openTelemetryConnection.isTurnOffTracing()).updateTraceConfiguration(traceLevelConfiguration);
        this.processorComponentService = ProcessorComponentService.getInstance();
    }

    public void handleProcessorStartEvent(MessageProcessorNotification notification) {
        String location = notification.getComponent().getLocation().getLocation();
        if (ComponentsUtil.isAsyncScope(notification.getComponent().getLocation().getComponentIdentifier())) {
            return;
        }
        if (this.interceptorProcessorConfig.interceptEnabled(notification.getComponent().getLocation())) {
            logger.trace("Component {} will be processed by interceptor, skipping notification processing to create span", (Object)location);
            return;
        }
        this.processComponentStartSpan((EnrichedServerNotification)notification);
    }

    public void handleAsyncScheduledEvent(AsyncMessageNotification notification) {
        this.processComponentStartSpan((EnrichedServerNotification)notification);
    }

    private void processComponentStartSpan(EnrichedServerNotification notification) {
        try {
            ProcessorComponent processorComponent = this.getProcessorComponent(notification.getComponent().getIdentifier());
            if (processorComponent != null) {
                logger.trace("Handling '{}:{}' processor start event context id {} correlation id {} ", new Object[]{notification.getResourceIdentifier(), notification.getComponent().getIdentifier(), notification.getEvent().getContext().getId(), notification.getEvent().getCorrelationId()});
                TraceComponent traceComponent = processorComponent.getStartTraceComponent(notification).withStartTime(Instant.ofEpochMilli(notification.getTimestamp())).withEventContextId(notification.getEvent().getContext().getId()).withComponentLocation(notification.getComponent().getLocation());
                OpenTelemetryUtil.resolveExpressions(traceComponent, this.openTelemetryConnection.getExpressionManager(), notification.getEvent());
                this.openTelemetryConnection.addProcessorSpan(traceComponent, ComponentsUtil.getLocationParent(notification.getComponent().getLocation().getLocation()));
                this.processFlowRef(traceComponent, notification.getEvent());
            }
        }
        catch (Exception ex) {
            logger.trace("Failed to intercept processor {} at {}, span may not be captured for this processor. Error - {}", new Object[]{notification.getComponent().getIdentifier().toString(), notification.getComponent().getLocation().getLocation(), ex.getLocalizedMessage(), ex});
        }
    }

    private void processFlowRef(TraceComponent traceComponent, Event event) {
        Optional<ComponentLocation> subFlowLocation;
        if (ComponentsUtil.isFlowRef(traceComponent.getComponentLocation()) && (subFlowLocation = ComponentsUtil.resolveFlowName(this.getOpenTelemetryConnection().getExpressionManager(), traceComponent, event.asBindingContext(), this.configurationComponentLocator)).isPresent()) {
            TraceComponent subflowTrace = ComponentsUtil.getTraceComponent(subFlowLocation.get(), traceComponent);
            this.getOpenTelemetryConnection().addProcessorSpan(subflowTrace, traceComponent.getComponentLocation().getLocation());
        }
    }

    ProcessorComponent getProcessorComponent(MessageProcessorNotification notification) {
        ComponentIdentifier identifier = notification.getComponent().getIdentifier();
        return this.getProcessorComponent(identifier);
    }

    public ProcessorComponent getProcessorComponent(ComponentIdentifier identifier) {
        boolean ignored = this.multiMapContains(identifier.getNamespace(), identifier.getName(), "*", this.traceLevelConfiguration.getIgnoreMuleComponentsMap());
        if (this.spanAllProcessors && ignored) {
            return null;
        }
        ProcessorComponent processorComponent = this.processorComponentService.getProcessorComponentFor(identifier, this.configurationComponentLocator, this.openTelemetryConnection.getExpressionManager());
        if (processorComponent == null && (this.spanAllProcessors || this.multiMapContains(identifier.getNamespace(), identifier.getName(), "*", this.traceLevelConfiguration.getSpanAdditionalMuleComponentsMap()))) {
            processorComponent = this.genericProcessorComponent;
        }
        return processorComponent;
    }

    private boolean multiMapContains(String key, String value, String alternate, MultiMap<String, String> multiMap) {
        List values = multiMap.getAll((Object)key);
        return values.contains(value) || values.contains(alternate);
    }

    public void handleProcessorEndEvent(EnrichedServerNotification notification) {
        String location = notification.getComponent().getLocation().getLocation();
        try {
            ProcessorComponent processorComponent = this.getProcessorComponent(notification.getComponent().getIdentifier());
            if (processorComponent != null) {
                logger.trace("Handling '{}:{}' processor end event context id {} correlation id {} ", new Object[]{notification.getResourceIdentifier(), notification.getComponent().getIdentifier(), notification.getEvent().getContext().getId(), notification.getEvent().getCorrelationId()});
                TraceComponent traceComponent = processorComponent.getEndTraceComponent(notification).withEndTime(Instant.ofEpochMilli(notification.getTimestamp())).withEventContextId(notification.getEvent().getContext().getId());
                SpanMeta spanMeta = this.openTelemetryConnection.endProcessorSpan(traceComponent, notification.getEvent().getError().orElse(null));
                if (ComponentsUtil.isFlowRef(notification.getComponent().getLocation())) {
                    String targetFlowName = traceComponent.getTags().get("mule.app.processor.flowRef.name");
                    if (this.openTelemetryConnection.getExpressionManager().isExpression(targetFlowName)) {
                        logger.trace("Resolving expression '{}'", (Object)targetFlowName);
                        targetFlowName = this.openTelemetryConnection.getExpressionManager().evaluate(targetFlowName, notification.getEvent().asBindingContext()).getValue().toString();
                        logger.trace("Resolved to value '{}'", (Object)targetFlowName);
                    }
                    ComponentsUtil.findLocation(targetFlowName, this.configurationComponentLocator).filter(ComponentsUtil::isSubFlow).ifPresent(subFlowComp -> {
                        TraceComponent subflowTrace = TraceComponent.of(subFlowComp).withTransactionId(traceComponent.getTransactionId()).withSpanName(subFlowComp.getLocation()).withSpanKind(SpanKind.INTERNAL).withTags(Collections.singletonMap(SemanticAttributes.MULE_APP_SCOPE_SUBFLOW_NAME.getKey(), subFlowComp.getLocation())).withStatsCode(traceComponent.getStatusCode()).withEndTime(traceComponent.getEndTime()).withContext(traceComponent.getContext()).withEventContextId(notification.getEvent().getContext().getId());
                        SpanMeta subFlow = this.openTelemetryConnection.endProcessorSpan(subflowTrace, notification.getEvent().getError().orElse(null));
                        if (subFlow != null) {
                            this.openTelemetryConnection.getMetricsProviders().captureProcessorMetrics(notification.getComponent(), notification.getEvent().getError().orElse(null), location, spanMeta);
                        }
                    });
                }
                if (spanMeta != null) {
                    this.openTelemetryConnection.getMetricsProviders().captureProcessorMetrics(notification.getComponent(), notification.getEvent().getError().orElse(null), location, spanMeta);
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error in handling processor end event", (Throwable)ex);
            throw ex;
        }
    }

    public void handleFlowStartEvent(PipelineMessageNotification notification) {
        try {
            logger.trace("Handling '{}' flow start event context id {} correlation id {} ", new Object[]{notification.getResourceIdentifier(), notification.getEvent().getContext().getId(), notification.getEvent().getCorrelationId()});
            TraceComponent traceComponent = this.flowProcessorComponent.getSourceStartTraceComponent((EnrichedServerNotification)notification, this.openTelemetryConnection).withStartTime(Instant.ofEpochMilli(notification.getTimestamp())).withEventContextId(notification.getEvent().getContext().getId());
            traceComponent = this.attemptAddingTraceContextIfMissing(notification, traceComponent);
            this.openTelemetryConnection.startTransaction(traceComponent);
        }
        catch (Exception ex) {
            logger.error("Error in handling {} flow start event", (Object)notification.getResourceIdentifier(), (Object)ex);
            throw ex;
        }
    }

    private TraceComponent attemptAddingTraceContextIfMissing(PipelineMessageNotification notification, TraceComponent traceComponent) {
        if (traceComponent.getContext() != null) {
            return traceComponent;
        }
        if (this.flowContextExpressions.containsKey(notification.getResourceIdentifier())) {
            String expression = this.flowContextExpressions.get(notification.getResourceIdentifier());
            logger.info("Getting context for {} with {}", (Object)notification.getResourceIdentifier(), (Object)expression);
            Context context = this.getContext(expression, (EnrichedServerNotification)notification);
            traceComponent = traceComponent.withContext(context);
        } else {
            for (String expression : CONTEXT_EXPRESSIONS) {
                if (traceComponent.getContext() != null) continue;
                try {
                    Context context = this.getContext(expression, (EnrichedServerNotification)notification);
                    if (context == null) continue;
                    traceComponent = traceComponent.withContext(context);
                    logger.info("Got context for {} with {}, adding to cache", (Object)notification.getResourceIdentifier(), (Object)expression);
                    this.flowContextExpressions.put(notification.getResourceIdentifier(), expression);
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        return traceComponent;
    }

    private Context getContext(String expression, EnrichedServerNotification notification) {
        try {
            TypedValue contextCarrier = this.openTelemetryConnection.getExpressionManager().evaluate(expression, notification.getEvent().asBindingContext());
            if (contextCarrier.getValue() != null && contextCarrier.getValue() instanceof Map) {
                HashMap resolved = new HashMap(((Map)contextCarrier.getValue()).size());
                ((Map)contextCarrier.getValue()).forEach((key, value) -> {
                    if (value instanceof byte[]) {
                        resolved.put(key.toString(), new String((byte[])value));
                    } else {
                        resolved.put(key.toString(), value.toString());
                    }
                });
                return this.openTelemetryConnection.getTraceContext(resolved, AbstractProcessorComponent.ContextMapGetter.INSTANCE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void handleFlowEndEvent(PipelineMessageNotification notification) {
        try {
            logger.trace("Handling '{}' flow end event context id {} correlation id {} ", new Object[]{notification.getResourceIdentifier(), notification.getEvent().getContext().getId(), notification.getEvent().getCorrelationId()});
            TraceComponent traceComponent = this.flowProcessorComponent.getSourceEndTraceComponent((EnrichedServerNotification)notification, this.openTelemetryConnection).withEndTime(Instant.ofEpochMilli(notification.getTimestamp())).withEventContextId(notification.getEvent().getContext().getId());
            TransactionMeta transactionMeta = this.openTelemetryConnection.endTransaction(traceComponent, notification.getException());
            if (transactionMeta == null) {
                TypedValue contextId = (TypedValue)notification.getEvent().getVariables().get("_OTEL_FLOW_CONTEXT_ID");
                if (contextId != null && contextId.getValue() != null) {
                    logger.trace("Attempting to find {} by {}", (Object)traceComponent, contextId.getValue());
                    traceComponent = traceComponent.withEventContextId((String)contextId.getValue());
                }
                transactionMeta = this.openTelemetryConnection.endTransaction(traceComponent, notification.getException());
            }
            if (transactionMeta != null) {
                this.openTelemetryConnection.getMetricsProviders().captureFlowMetrics(transactionMeta, notification.getResourceIdentifier(), notification.getException());
            }
        }
        catch (Exception ex) {
            logger.error("Error in handling {} flow end event", (Object)notification.getResourceIdentifier(), (Object)ex);
            throw ex;
        }
    }
}

