/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor.db;

import com.avioconsulting.mule.opentelemetry.internal.processor.db.DBInfo;
import com.avioconsulting.mule.opentelemetry.internal.processor.db.JDBCUrlParser;
import java.util.Collections;
import java.util.Map;

public class DBConnectionConfigParser {
    public static DBInfo getDBInfo(String connectionName, Map<String, String> connectionParams) {
        String host = connectionParams.get("host");
        String port = connectionParams.get("port");
        String database = connectionParams.get("database");
        String instance = connectionParams.get("instance");
        String serviceName = connectionParams.get("serviceName");
        switch (connectionName) {
            case "mysql": {
                return new DBInfo("mysql", host, port, database, instance, serviceName, JDBCUrlParser.resolveNamespace("mysql", host, port, database, instance, serviceName), connectionParams);
            }
            case "oracle": {
                return new DBInfo("oracle", host, port, database, instance, serviceName, JDBCUrlParser.resolveNamespace("oracle", host, port, database, instance, serviceName), connectionParams);
            }
            case "mssql": {
                instance = connectionParams.get("instanceName");
                database = connectionParams.get("databaseName");
                return new DBInfo("mssql", host, port, database, instance, serviceName, JDBCUrlParser.resolveNamespace("mssql", host, port, database, instance, serviceName), connectionParams);
            }
            case "derby": {
                String subsubProtocol = connectionParams.getOrDefault("subsubProtocol", "");
                return new DBInfo("mssql", host, port, database, instance, serviceName, subsubProtocol + ":" + database, connectionParams);
            }
        }
        return new DBInfo("other_sql", null, null, null, null, null, "", Collections.emptyMap());
    }
}

