/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.util;

import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetryUtil.class);

    public static void addGlobalConfigSystemAttributes(String configName, Map<String, String> tags, Map<String, String> sourceMap) {
        if (configName == null || configName.trim().isEmpty()) {
            return;
        }
        Objects.requireNonNull(tags, "Tags map cannot be null");
        String configRef = configName.toLowerCase();
        String replaceVal = configRef + ".otel.";
        sourceMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(configRef)).forEach(entry -> {
            String propKey = ((String)entry.getKey()).substring(replaceVal.length());
            tags.put(propKey, (String)entry.getValue());
        });
    }

    public static String getEventTransactionId(Event event) {
        return OpenTelemetryUtil.getEventTransactionId(event.getContext().getId());
    }

    public static String getEventTransactionId(String eventId) {
        return eventId.split("_")[0];
    }

    public static void addAttribute(String property, AttributesBuilder builder, AttributeKey<String> attributeKey) {
        String value = PropertiesUtil.getProperty(property);
        if (value != null) {
            builder.put(attributeKey, (Object)value);
        }
    }

    public static void resolveExpressions(TraceComponent traceComponent, ExpressionManager expressionManager, Event event) {
        try {
            String value;
            if (expressionManager.isExpression(traceComponent.getSpanName()) && (value = OpenTelemetryUtil.resolveExpression(traceComponent.getSpanName(), expressionManager, event)) != null) {
                traceComponent.withSpanName(value);
            }
            List expressionTags = traceComponent.getTags().entrySet().stream().filter(e -> expressionManager.isExpression((String)e.getValue())).collect(Collectors.toList());
            for (Map.Entry expressionTag : expressionTags) {
                String value2 = OpenTelemetryUtil.resolveExpression((String)expressionTag.getValue(), expressionManager, event);
                if (value2 == null) continue;
                traceComponent.getTags().replace((String)expressionTag.getKey(), value2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String resolveExpression(String expression, ExpressionManager expressionManager, Event event) throws Exception {
        TypedValue evaluate = expressionManager.evaluate(expression, DataType.STRING, event.asBindingContext());
        return OpenTelemetryUtil.typedValueToString(evaluate);
    }

    public static String typedValueToString(TypedValue typedValue) throws Exception {
        String value = "";
        Object input = typedValue.getValue();
        value = input instanceof CursorStreamProvider ? IOUtils.toString((InputStream)((InputStream)((CursorStreamProvider)input).openCursor())) : (input instanceof InputStream ? IOUtils.toString((InputStream)((InputStream)input)) : TypedValue.unwrap((Object)typedValue).toString());
        return value;
    }
}

