/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.api;

import com.avioconsulting.mule.vault.provider.internal.error.exception.SecretNotFoundException;
import com.avioconsulting.mule.vault.provider.internal.error.exception.UnsetVariableException;
import com.avioconsulting.mule.vault.provider.internal.error.exception.VaultAccessException;
import com.avioconsulting.mule.vault.provider.internal.extension.VaultPropertyPath;
import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultException;
import java.io.FileInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultConfigurationPropertiesProvider
implements ConfigurationPropertiesProvider {
    private static final Logger logger = LoggerFactory.getLogger(VaultConfigurationPropertiesProvider.class);
    private static final String VAULT_PROPERTIES_PREFIX = "vault::";
    private static final Pattern VAULT_PATTERN = Pattern.compile("vault::([^\\.]*)\\.([^}]*)");
    private static final Pattern ENV_PATTERN = Pattern.compile("\\$\\[([^\\]]*)\\]");
    private final Vault vault;
    private final boolean isLocalMode;
    Map<String, Map<String, String>> cachedData;

    public VaultConfigurationPropertiesProvider(Vault vault, Boolean isLocalMode, String localPropertiesFile) {
        this.vault = vault;
        this.cachedData = new HashMap<String, Map<String, String>>();
        this.isLocalMode = isLocalMode;
        if (isLocalMode.booleanValue()) {
            this.evaluateLocalProperitesConfig(localPropertiesFile);
        }
    }

    private String getProperty(String path, String property) throws SecretNotFoundException, VaultAccessException, DefaultMuleException {
        try {
            Map data = null;
            if (this.cachedData.containsKey(path)) {
                logger.trace("Getting data from cache");
                data = this.cachedData.get(path);
            } else if (!this.isLocalMode) {
                logger.trace("Getting data from Vault");
                data = this.vault.logical().read(path).getData();
                this.cachedData.put(path, data);
            } else {
                throw new SecretNotFoundException(String.format("No property found for %s.%s in the local properties file", path, property));
            }
            if (data != null && data.containsKey(property)) {
                return (String)data.get(property);
            }
            throw new SecretNotFoundException(String.format("No value found for %s.%s", path, property));
        }
        catch (VaultException ve) {
            if (ve.getHttpStatusCode() == 404) {
                throw new SecretNotFoundException("Error getting data from Vault, secret not found", ve);
            }
            if (ve.getHttpStatusCode() == 403) {
                throw new VaultAccessException(String.format("Access to the secret at \"%s\" is denied", path), ve);
            }
            logger.error("Error getting data from Vault", (Throwable)ve);
            throw new DefaultMuleException("Unknown Vault exception", (Throwable)ve);
        }
    }

    public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
        VaultPropertyPath path;
        Optional<ConfigurationProperty> optionalValue = Optional.empty();
        if (configurationAttributeKey.startsWith(VAULT_PROPERTIES_PREFIX) && (path = this.parsePropertyPath(configurationAttributeKey)) != null) {
            try {
                final String value = this.getProperty(path.getSecretPath(), path.getKey());
                if (value != null) {
                    return Optional.of(new ConfigurationProperty(){

                        public Object getSource() {
                            return "Vault provider source";
                        }

                        public Object getRawValue() {
                            return value;
                        }

                        public String getKey() {
                            return String.format("%s.%s", path.getSecretPath(), path.getKey());
                        }
                    });
                }
            }
            catch (Exception e) {
                logger.error("Property was not found", (Throwable)e);
            }
        }
        return optionalValue;
    }

    public String getDescription() {
        return "Vault properties provider";
    }

    private VaultPropertyPath parsePropertyPath(String configurationAttributeKey) {
        Matcher matcher = VAULT_PATTERN.matcher(configurationAttributeKey);
        if (matcher.find()) {
            String secretPath = matcher.group(1);
            String key = matcher.group(2);
            return new VaultPropertyPath(this.expandedValue(secretPath), this.expandedValue(key));
        }
        return null;
    }

    private String expandedValue(String value) {
        String result = value;
        Matcher envMatcher = ENV_PATTERN.matcher(value);
        while (envMatcher.find()) {
            String envVariableName = envMatcher.group(1);
            String envValue = System.getenv(envVariableName);
            if (envValue == null) {
                envValue = System.getProperty(envVariableName);
                logger.debug("Retrieved environment value from property rather than environment");
            }
            if (envValue != null) {
                result = result.replaceAll("\\$\\[" + envVariableName + "\\]", envValue);
                continue;
            }
            throw new UnsetVariableException(String.format("Environment variable [%s] is not set", envVariableName));
        }
        return result;
    }

    private void evaluateLocalProperitesConfig(String localPropertiesFile) {
        if (localPropertiesFile == null || localPropertiesFile.isEmpty()) {
            return;
        }
        try {
            URL resourceUrl = this.getClass().getClassLoader().getResource(localPropertiesFile);
            if (resourceUrl == null) {
                return;
            }
            Properties appProps = new Properties();
            appProps.load(new FileInputStream(resourceUrl.getPath()));
            this.loadCacheFromProperties(appProps);
        }
        catch (Exception e) {
            logger.error(String.format("Error occurred while loading the local properties file from %s", localPropertiesFile), (Throwable)e);
        }
    }

    private void loadCacheFromProperties(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        properties.entrySet().forEach(entry -> {
            String keyS = entry.getKey().toString();
            final String[] pathElements = keyS.split("\\.");
            if (pathElements.length != 2) {
                logger.warn(String.format("Invalid property secret path in local properties file (%s). Property must be in this format: path/to/secret/engine.key", keyS));
            } else if (this.cachedData.containsKey(pathElements[0])) {
                this.cachedData.get(pathElements[0]).put(pathElements[1], entry.getValue().toString());
            } else {
                this.cachedData.put(pathElements[0], (Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put(pathElements[1], entry.getValue().toString());
                    }
                });
            }
        });
    }
}

