/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.api;

import com.avioconsulting.mule.vault.provider.api.VaultConfigurationPropertiesProvider;
import com.avioconsulting.mule.vault.provider.internal.connection.VaultConnection;
import com.avioconsulting.mule.vault.provider.internal.connection.provider.AbstractConnectionProvider;
import com.avioconsulting.mule.vault.provider.internal.connection.provider.AppRoleConnectionProvider;
import com.avioconsulting.mule.vault.provider.internal.connection.provider.Ec2ConnectionProvider;
import com.avioconsulting.mule.vault.provider.internal.connection.provider.IamConnectionProvider;
import com.avioconsulting.mule.vault.provider.internal.connection.provider.TlsConnectionProvider;
import com.avioconsulting.mule.vault.provider.internal.connection.provider.TokenConnectionProvider;
import com.avioconsulting.mule.vault.provider.internal.extension.VaultPropertiesProviderExtension;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultConfigurationPropertiesProviderFactory
implements ConfigurationPropertiesProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(VaultConfigurationPropertiesProviderFactory.class);
    public static final String TOKEN_PARAMETER_GROUP = "token-connection";
    public static final String TLS_PARAMETER_GROUP = "tls-connection";
    public static final String IAM_PARAMETER_GROUP = "iam-connection";
    public static final String EC2_PARAMETER_GROUP = "ec2-connection";
    public static final String APPROLE_PARAMETER_GROUP = "approle-connection";

    public ComponentIdentifier getSupportedComponentIdentifier() {
        return VaultPropertiesProviderExtension.VAULT_PROPERTIES_PROVIDER;
    }

    public ConfigurationPropertiesProvider createProvider(ConfigurationParameters parameters, ResourceProvider externalResourceProvider) {
        try {
            AbstractConnectionProvider vaultConnectionProvider = this.getVaultConnectionProvider(parameters);
            return new VaultConfigurationPropertiesProvider(((VaultConnection)vaultConnectionProvider.connect()).getVault(), vaultConnectionProvider.isLocalMode(), vaultConnectionProvider.getLocalPropertiesFile());
        }
        catch (ConnectionException ce) {
            logger.error("Error connecting to Vault", (Throwable)ce);
            return null;
        }
    }

    private AbstractConnectionProvider getVaultConnectionProvider(ConfigurationParameters parameters) throws ConnectionException {
        if (parameters.getComplexConfigurationParameters().size() > 1) {
            logger.warn("Multiple Vault Properties Provider configurations have been found");
        }
        AbstractConnectionProvider connectionProvider = null;
        for (int i = 0; i < parameters.getComplexConfigurationParameters().size(); ++i) {
            String namespace = ((ComponentIdentifier)((Pair)parameters.getComplexConfigurationParameters().get(i)).getFirst()).getNamespace();
            if (!namespace.equals(VaultPropertiesProviderExtension.VAULT_PROPERTIES_PROVIDER.getNamespace())) continue;
            String firstConfiguration = ((ComponentIdentifier)((Pair)parameters.getComplexConfigurationParameters().get(i)).getFirst()).getName();
            ConfigurationParameters configurationParameters = (ConfigurationParameters)((Pair)parameters.getComplexConfigurationParameters().get(i)).getSecond();
            if (TLS_PARAMETER_GROUP.equals(firstConfiguration)) {
                connectionProvider = new TlsConnectionProvider(configurationParameters);
                break;
            }
            if (TOKEN_PARAMETER_GROUP.equals(firstConfiguration)) {
                connectionProvider = new TokenConnectionProvider(configurationParameters);
                break;
            }
            if (IAM_PARAMETER_GROUP.equals(firstConfiguration)) {
                connectionProvider = new IamConnectionProvider(configurationParameters);
                break;
            }
            if (EC2_PARAMETER_GROUP.equals(firstConfiguration)) {
                connectionProvider = new Ec2ConnectionProvider(configurationParameters);
                break;
            }
            if (!APPROLE_PARAMETER_GROUP.equals(firstConfiguration)) break;
            connectionProvider = new AppRoleConnectionProvider(configurationParameters);
            break;
        }
        if (connectionProvider != null) {
            return connectionProvider;
        }
        logger.warn("No Vault Properties Provider configurations found");
        return null;
    }
}

