/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.api.connection.parameters;

import java.util.List;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSIdentityProperties {
    private static final Logger logger = LoggerFactory.getLogger(AWSIdentityProperties.class);
    private static final String IDENTITY_PARAMETER_GROUP = "identity-properties";
    @DisplayName(value="Identity Document")
    @Summary(value="Base64 encoded EC2 instance identity document.")
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String identity;
    @DisplayName(value="Identity Document Signature")
    @Summary(value="Base64 encoded SHA256 RSA signature of the instance identity document")
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String signature;

    public AWSIdentityProperties() {
    }

    public AWSIdentityProperties(ConfigurationParameters parameters) {
        List idList = parameters.getComplexConfigurationParameter(ComponentIdentifier.builder().namespace("vault-properties-provider").name(IDENTITY_PARAMETER_GROUP).build());
        if (idList.size() > 0) {
            ConfigurationParameters idParameters = (ConfigurationParameters)idList.get(0);
            try {
                this.identity = idParameters.getStringParameter("identity");
                this.signature = idParameters.getStringParameter("signature");
            }
            catch (Exception ide) {
                logger.debug("identity and/or signature properties are not present. If one is set, both must be set", (Throwable)ide);
            }
        }
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }
}

