/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.api.connection.parameters;

import com.avioconsulting.mule.vault.provider.api.connection.parameters.AWSIdentityProperties;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExclusiveOptionals(isOneRequired=true)
public class EC2ConnectionProperties {
    private static final Logger logger = LoggerFactory.getLogger(EC2ConnectionProperties.class);
    @DisplayName(value="Use Instance Metadata")
    @Summary(value="Retrieve Instance metadata")
    @Parameter
    @Optional
    private boolean useInstanceMetadata = false;
    @DisplayName(value="PKCS7 Signature")
    @Summary(value="PKCS7 signature of the identity document with all \\n characters removed.")
    @Parameter
    @Optional
    private String pkcs7;
    @DisplayName(value="Identity Properties")
    @Summary(value="EC2 Identity Properties")
    @Parameter
    @Optional
    private AWSIdentityProperties identityProperties;

    public EC2ConnectionProperties() {
    }

    public EC2ConnectionProperties(ConfigurationParameters parameters) {
        try {
            this.pkcs7 = parameters.getStringParameter("pkcs7");
        }
        catch (Exception e) {
            logger.debug("pkcs7 value is not set", (Throwable)e);
        }
        try {
            String useMetadataStr = parameters.getStringParameter("useInstanceMetadata");
            this.useInstanceMetadata = "true".equals(useMetadataStr);
        }
        catch (Exception e) {
            logger.debug("useInstanceMetadata value is not set", (Throwable)e);
        }
        this.identityProperties = new AWSIdentityProperties(parameters);
    }

    public boolean isUseInstanceMetadata() {
        return this.useInstanceMetadata;
    }

    public void setUseInstanceMetadata(boolean useInstanceMetadata) {
        this.useInstanceMetadata = useInstanceMetadata;
    }

    public String getPkcs7() {
        return this.pkcs7;
    }

    public void setPkcs7(String pkcs7) {
        this.pkcs7 = pkcs7;
    }

    public AWSIdentityProperties getIdentityProperties() {
        return this.identityProperties;
    }

    public void setIdentityProperties(AWSIdentityProperties identityProperties) {
        this.identityProperties = identityProperties;
    }
}

