/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.api.connection.parameters;

import com.avioconsulting.mule.vault.provider.api.connection.parameters.KeyStoreConfig;
import com.avioconsulting.mule.vault.provider.api.connection.parameters.TrustStoreConfig;
import java.util.List;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsContext {
    private static final Logger logger = LoggerFactory.getLogger(TlsContext.class);
    @Parameter
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="trust-store")
    @DisplayName(value="Trust Store Configuration")
    private TrustStoreConfig trustStoreConfig;
    @Parameter
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="key-store")
    @DisplayName(value="Key Store Configuration")
    private KeyStoreConfig keyStoreConfig;

    public TlsContext() {
    }

    public TlsContext(ConfigurationParameters parameters) {
        List tlsContextList = parameters.getComplexConfigurationParameter(ComponentIdentifier.builder().namespace("vault-properties-provider").name("tls-context").build());
        if (tlsContextList.size() > 0) {
            List keyStoreParams;
            logger.info("Found TLS Context");
            ConfigurationParameters tlsParameters = (ConfigurationParameters)tlsContextList.get(0);
            List trustStoreParams = tlsParameters.getComplexConfigurationParameter(ComponentIdentifier.builder().namespace("vault-properties-provider").name("trust-store").build());
            if (trustStoreParams.size() > 0) {
                logger.info("Found Trust Store Config");
                this.trustStoreConfig = new TrustStoreConfig((ConfigurationParameters)trustStoreParams.get(0));
            }
            if ((keyStoreParams = tlsParameters.getComplexConfigurationParameter(ComponentIdentifier.builder().namespace("vault-properties-provider").name("key-store").build())).size() > 0) {
                logger.info("Found Key Store Config");
                this.keyStoreConfig = new KeyStoreConfig((ConfigurationParameters)keyStoreParams.get(0));
            }
        }
    }

    public TrustStoreConfig getTrustStoreConfig() {
        return this.trustStoreConfig;
    }

    public KeyStoreConfig getKeyStoreConfig() {
        return this.keyStoreConfig;
    }

    public boolean isTrustStoreConfigured() {
        return this.trustStoreConfig != null;
    }

    public boolean isKeyStoreConfigured() {
        return this.keyStoreConfig != null;
    }
}

