/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.internal.connection.impl;

import com.avioconsulting.mule.vault.provider.api.connection.parameters.TlsContext;
import com.avioconsulting.mule.vault.provider.internal.connection.VaultConnection;
import com.bettercloud.vault.SslConfig;
import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public abstract class AbstractConnection
implements VaultConnection {
    protected boolean valid = false;
    protected Vault vault = null;
    protected VaultConfig vaultConfig = new VaultConfig();

    @Override
    public Vault getVault() {
        return this.vault;
    }

    @Override
    public void invalidate() {
        this.valid = false;
        this.vault = null;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public SslConfig getVaultSSLConfig(TlsContext tlsContext) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        SslConfig ssl = new SslConfig();
        if (tlsContext != null) {
            if (tlsContext.isTrustStoreConfigured()) {
                ssl = ssl.trustStore(tlsContext.getTrustStoreConfig().getKeyStore()).verify(Boolean.valueOf(!tlsContext.getTrustStoreConfig().isInsecure()));
            }
            if (tlsContext.isKeyStoreConfigured()) {
                ssl = ssl.keyStore(tlsContext.getKeyStoreConfig().getKeyStore(), tlsContext.getKeyStoreConfig().getPassword());
            }
        }
        return ssl;
    }

    boolean classpathResourceExists(String path) {
        File file;
        boolean fileExists = false;
        URL fileUrl = this.getClass().getResource(path);
        if (fileUrl != null && (file = new File(fileUrl.getFile())) != null) {
            fileExists = file.exists();
        }
        return fileExists;
    }
}

