/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.internal.connection.impl;

import com.avioconsulting.mule.vault.provider.api.connection.parameters.EngineVersion;
import com.avioconsulting.mule.vault.provider.api.connection.parameters.TlsContext;
import com.avioconsulting.mule.vault.provider.internal.connection.impl.AbstractConnection;
import com.bettercloud.vault.SslConfig;
import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.mule.runtime.api.connection.ConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenConnection
extends AbstractConnection {
    private static final Logger logger = LoggerFactory.getLogger(TokenConnection.class);

    public TokenConnection(String vaultUrl, String vaultToken, TlsContext tlsContext, EngineVersion engineVersion, int prefixPathDepth) throws ConnectionException {
        try {
            this.vaultConfig = new VaultConfig().address(vaultUrl).prefixPathDepth(prefixPathDepth);
            if (engineVersion != null) {
                this.vaultConfig = this.vaultConfig.engineVersion(engineVersion.getEngineVersionNumber());
            }
            SslConfig ssl = this.getVaultSSLConfig(tlsContext);
            this.vault = new Vault(this.vaultConfig.token(vaultToken).sslConfig(ssl.build()).build());
            logger.debug("TLS Setup Complete");
            this.valid = true;
        }
        catch (VaultException | IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ve) {
            throw new ConnectionException(ve.getMessage(), ve.getCause());
        }
    }
}

