/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.internal.connection.provider;

import com.avioconsulting.mule.vault.provider.api.connection.parameters.EC2ConnectionProperties;
import com.avioconsulting.mule.vault.provider.api.connection.parameters.TlsContext;
import com.avioconsulting.mule.vault.provider.internal.connection.VaultConnection;
import com.avioconsulting.mule.vault.provider.internal.connection.impl.Ec2Connection;
import com.avioconsulting.mule.vault.provider.internal.connection.provider.AbstractAWSConnectionProvider;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestException;
import com.bettercloud.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisplayName(value="EC2 Connection")
@Alias(value="ec2-connection")
@ExclusiveOptionals(isOneRequired=true)
public class Ec2ConnectionProvider
extends AbstractAWSConnectionProvider {
    private static final String INSTANCE_PKCS7_URI = "http://169.254.169.254/latest/dynamic/instance-identity/pkcs7";
    private static final Logger logger = LoggerFactory.getLogger(Ec2ConnectionProvider.class);
    @ParameterGroup(name="EC2 Properties")
    EC2ConnectionProperties connectionProperties;
    @DisplayName(value="TLS Context")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Placement(tab="Security")
    @Parameter
    @Optional
    protected TlsContext tlsContext;
    private String pkcs7Uri;

    public Ec2ConnectionProvider() {
        this.setPkcs7Uri();
    }

    public Ec2ConnectionProvider(ConfigurationParameters parameters) {
        super(parameters);
        this.setPkcs7Uri();
        this.connectionProperties = new EC2ConnectionProperties(parameters);
        this.tlsContext = new TlsContext(parameters);
    }

    @Override
    protected TlsContext getTlsContext() {
        return this.tlsContext;
    }

    private void setPkcs7Uri() {
        this.pkcs7Uri = System.getProperty("INSTANCE_PKCS7_URI");
        if (this.pkcs7Uri == null || this.pkcs7Uri.isEmpty()) {
            this.pkcs7Uri = INSTANCE_PKCS7_URI;
        }
    }

    public VaultConnection connect() throws ConnectionException {
        if (this.connectionProperties != null) {
            boolean identityUnavailable;
            if (this.connectionProperties.isUseInstanceMetadata()) {
                this.connectionProperties.setPkcs7(this.lookupPkcs7());
            }
            boolean pkcsUnavailable = this.connectionProperties.getPkcs7() == null || this.connectionProperties.getPkcs7().isEmpty();
            boolean bl = identityUnavailable = this.connectionProperties.getIdentityProperties().getIdentity() == null || this.connectionProperties.getIdentityProperties().getIdentity().isEmpty() || this.connectionProperties.getIdentityProperties().getSignature() == null || this.connectionProperties.getIdentityProperties().getSignature().isEmpty();
            if (pkcsUnavailable && identityUnavailable) {
                logger.error("PKCS7 Signature, Identity Document, and Identity Signature are all null or empty");
                throw new ConnectionException("PKCS7 Signature or the Identity Document and Signature are required");
            }
            return new Ec2Connection(this.vaultUrl, this.vaultRole, this.connectionProperties.getPkcs7(), null, this.connectionProperties.getIdentityProperties().getIdentity(), this.connectionProperties.getIdentityProperties().getSignature(), this.awsAuthMount, this.getTlsContext(), this.engineVersion, this.prefixPathDepth);
        }
        return null;
    }

    private String lookupPkcs7() {
        String pkcs7 = null;
        try {
            RestResponse response = new Rest().url(this.pkcs7Uri).get();
            String responseStr = new String(response.getBody(), StandardCharsets.UTF_8);
            pkcs7 = responseStr.replaceAll("\n", "");
        }
        catch (RestException re) {
            logger.error("Error looking up PKCS7 from Metadata Service", (Throwable)re);
        }
        return pkcs7;
    }
}

