/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.internal.connection.provider;

import com.avioconsulting.mule.vault.provider.api.connection.parameters.TlsContext;
import com.avioconsulting.mule.vault.provider.internal.connection.VaultConnection;
import com.avioconsulting.mule.vault.provider.internal.connection.impl.IamConnection;
import com.avioconsulting.mule.vault.provider.internal.connection.provider.AbstractAWSConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisplayName(value="IAM Connection")
@Alias(value="iam-connection")
public class IamConnectionProvider
extends AbstractAWSConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(IamConnectionProvider.class);
    @DisplayName(value="IAM Request URL")
    @Summary(value="Most likely https://sts.amazonaws.com/")
    @Parameter
    @Optional(defaultValue="https://sts.amazonaws.com/")
    private String iamRequestUrl = "https://sts.amazonaws.com/";
    @DisplayName(value="IAM Request Body")
    @Summary(value="Body of the signed request")
    @Parameter
    private String iamRequestBody;
    @DisplayName(value="IAM Request Headers")
    @Parameter
    private String iamRequestHeaders;
    @DisplayName(value="TLS Context")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Placement(tab="Security")
    @Parameter
    @Optional
    protected TlsContext tlsContext;

    public IamConnectionProvider() {
    }

    public IamConnectionProvider(ConfigurationParameters parameters) {
        super(parameters);
        this.tlsContext = new TlsContext(parameters);
        try {
            this.iamRequestUrl = parameters.getStringParameter("iamRequestUrl");
            this.iamRequestBody = parameters.getStringParameter("iamRequestBody");
            this.iamRequestHeaders = parameters.getStringParameter("iamRequestHeaders");
        }
        catch (Exception e) {
            logger.debug("All IAM properties must be present (iamAwsAuthMount, iamVaultRole, iamUrl, iamReqBody, iamReqHeaders)", (Throwable)e);
        }
    }

    @Override
    protected TlsContext getTlsContext() {
        return this.tlsContext;
    }

    public VaultConnection connect() throws ConnectionException {
        return new IamConnection(this.vaultUrl, this.awsAuthMount, this.vaultRole, this.iamRequestUrl, this.iamRequestBody, this.iamRequestHeaders, this.getTlsContext(), this.engineVersion, this.prefixPathDepth);
    }
}

