/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.internal.connection.impl;

import com.avioconsulting.mule.vault.provider.api.connection.parameters.TlsContext;
import com.avioconsulting.mule.vault.provider.internal.connection.impl.AbstractConnection;
import com.avioconsulting.mule.vault.provider.internal.connection.provider.AbstractConnectionProvider;
import io.github.jopenlibs.vault.SslConfig;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.mule.runtime.api.connection.ConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppRoleConnection
extends AbstractConnection {
    private static final Logger logger = LoggerFactory.getLogger(AppRoleConnection.class);

    public AppRoleConnection(String authMount, String roleId, String secretId, TlsContext tlsContext) throws ConnectionException {
        try {
            SslConfig ssl = this.getVaultSSLConfig(tlsContext);
            AbstractConnectionProvider.vaultConfig = AbstractConnectionProvider.vaultConfig.sslConfig(ssl.build());
            this.vault = new Vault(AbstractConnectionProvider.vaultConfig.build());
            String token = this.vault.auth().loginByAppRole(authMount, roleId, secretId).getAuthClientToken();
            this.vault = new Vault(AbstractConnectionProvider.vaultConfig.sslConfig(ssl.build()).token(token).build());
            logger.debug("Successfully authenticated with AppRole auth method");
            this.valid = true;
        }
        catch (VaultException | IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ve) {
            logger.error("Error trying to stablish approle connection", ve);
            throw new ConnectionException(ve.getMessage(), ve.getCause());
        }
    }
}

