/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.internal.connection.impl;

import com.avioconsulting.mule.vault.provider.api.connection.parameters.TlsContext;
import com.avioconsulting.mule.vault.provider.internal.connection.impl.AbstractConnection;
import com.avioconsulting.mule.vault.provider.internal.connection.provider.AbstractConnectionProvider;
import io.github.jopenlibs.vault.SslConfig;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.mule.runtime.api.connection.ConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsConnection
extends AbstractConnection {
    private static final Logger logger = LoggerFactory.getLogger(TlsConnection.class);

    public TlsConnection(TlsContext tlsContext) throws ConnectionException {
        try {
            SslConfig ssl = this.getVaultSSLConfig(tlsContext);
            AbstractConnectionProvider.vaultConfig = AbstractConnectionProvider.vaultConfig.sslConfig(ssl.build());
            logger.debug("TLS Setup Complete");
            Vault vaultDriver = new Vault(AbstractConnectionProvider.vaultConfig.build());
            String vaultToken = vaultDriver.auth().loginByCert().getAuthClientToken();
            this.vault = new Vault(AbstractConnectionProvider.vaultConfig.sslConfig(ssl.build()).token(vaultToken).build());
            this.valid = true;
        }
        catch (VaultException | IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ve) {
            throw new ConnectionException(ve);
        }
    }
}

