/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.internal.connection.provider;

import com.avioconsulting.mule.vault.provider.api.connection.parameters.EngineVersion;
import com.avioconsulting.mule.vault.provider.api.connection.parameters.TlsContext;
import com.avioconsulting.mule.vault.provider.internal.connection.VaultConnection;
import io.github.jopenlibs.vault.VaultConfig;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionProvider
implements ConnectionProvider<VaultConnection> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnectionProvider.class);
    public static VaultConfig vaultConfig = new VaultConfig();
    @DisplayName(value="Vault URL")
    @Parameter
    protected String vaultUrl;
    @DisplayName(value="Vault Namespace")
    @Parameter
    @Optional
    protected String vaultNamespace;
    @DisplayName(value="Secrets Engine Version")
    @Parameter
    @Optional
    protected EngineVersion engineVersion;
    @DisplayName(value="Local Mode Enabled")
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.SUPPORTED)
    protected boolean localMode;
    @DisplayName(value="Local Properties File")
    @Parameter
    @Optional
    protected String localPropertiesFile;
    @DisplayName(value="Prefix path depth")
    @Parameter
    @Optional(defaultValue="1")
    protected int prefixPathDepth;

    protected abstract TlsContext getTlsContext();

    public AbstractConnectionProvider() {
    }

    public AbstractConnectionProvider(ConfigurationParameters parameters) {
        this.vaultUrl = parameters.getStringParameter("vaultUrl");
        this.vaultNamespace = parameters.getStringParameter("vaultNamespace");
        this.prefixPathDepth = Integer.valueOf(parameters.getStringParameter("prefixPathDepth"));
        this.localMode = Boolean.parseBoolean(parameters.getStringParameter("localMode"));
        try {
            String ev = parameters.getStringParameter("engineVersion");
            this.engineVersion = EngineVersion.valueOf(ev);
            vaultConfig.address(this.vaultUrl).prefixPathDepth(this.prefixPathDepth);
            if (this.engineVersion != null) {
                vaultConfig.engineVersion(this.engineVersion.getEngineVersionNumber());
            }
            if (this.vaultNamespace != null) {
                vaultConfig.nameSpace(this.vaultNamespace);
            }
        }
        catch (Exception e) {
            logger.debug("kvVersion parameter is not present, or is not a valid value (v1 or v2)", (Throwable)e);
        }
        if (this.localMode) {
            try {
                this.localPropertiesFile = parameters.getStringParameter("localPropertiesFile");
            }
            catch (Exception e) {
                logger.debug("localPropertiesFile parameter is not present", (Throwable)e);
            }
        }
    }

    public void disconnect(VaultConnection connection) {
        connection.invalidate();
    }

    public ConnectionValidationResult validate(VaultConnection vaultConnection) {
        if (vaultConnection.isValid()) {
            return ConnectionValidationResult.success();
        }
        return ConnectionValidationResult.failure((String)"Invalid Connection", null);
    }

    public boolean isLocalMode() {
        return this.localMode;
    }

    public String getLocalPropertiesFile() {
        return this.localPropertiesFile;
    }
}

