/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.internal.connection.provider;

import com.avioconsulting.mule.vault.provider.api.connection.parameters.TlsContext;
import com.avioconsulting.mule.vault.provider.internal.connection.VaultConnection;
import com.avioconsulting.mule.vault.provider.internal.connection.impl.AppRoleConnection;
import com.avioconsulting.mule.vault.provider.internal.connection.provider.AbstractConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisplayName(value="AppRole Connection")
@Alias(value="approle-connection")
public class AppRoleConnectionProvider
extends AbstractConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(AppRoleConnectionProvider.class);
    @DisplayName(value="AppRole Mount")
    @Summary(value="Mount point for AppRole Authentication in Vault")
    @Parameter
    @Optional(defaultValue="approle")
    private String authMount;
    @DisplayName(value="Vault Role Id")
    @Parameter
    private String roleId;
    @DisplayName(value="Vault Secret Id")
    @Parameter
    private String secretId;
    @DisplayName(value="TLS Context")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Placement(tab="Security")
    @Parameter
    @Optional
    protected TlsContext tlsContext;

    public AppRoleConnectionProvider() {
    }

    public AppRoleConnectionProvider(ConfigurationParameters parameters) {
        super(parameters);
        this.tlsContext = new TlsContext(parameters);
        try {
            this.roleId = parameters.getStringParameter("roleId");
            this.secretId = parameters.getStringParameter("secretId");
            this.authMount = parameters.getStringParameter("authMount");
        }
        catch (Exception e) {
            logger.debug("Role Id or Secret Id is not present", (Throwable)e);
        }
    }

    @Override
    protected TlsContext getTlsContext() {
        return this.tlsContext;
    }

    public VaultConnection connect() throws ConnectionException {
        return new AppRoleConnection(this.authMount, this.roleId, this.secretId, this.getTlsContext());
    }
}

