/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.internal.connection.provider;

import com.avioconsulting.mule.vault.provider.api.connection.parameters.TlsContext;
import com.avioconsulting.mule.vault.provider.internal.connection.VaultConnection;
import com.avioconsulting.mule.vault.provider.internal.connection.impl.TlsConnection;
import com.avioconsulting.mule.vault.provider.internal.connection.provider.AbstractConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisplayName(value="TLS Connection")
@Alias(value="tls-connection")
public class TlsConnectionProvider
extends AbstractConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(TlsConnectionProvider.class);
    @DisplayName(value="TLS Context")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Parameter
    protected TlsContext tlsContext;

    public TlsConnectionProvider() {
    }

    public TlsConnectionProvider(ConfigurationParameters parameters) {
        super(parameters);
        this.tlsContext = new TlsContext(parameters);
    }

    @Override
    protected TlsContext getTlsContext() {
        return this.tlsContext;
    }

    public VaultConnection connect() throws ConnectionException {
        if (this.tlsContext == null) {
            throw new ConnectionException("TLS Context is required for TLS Connection");
        }
        return new TlsConnection(this.getTlsContext());
    }
}

