/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.vault.provider.internal.connection.provider;

import com.avioconsulting.mule.vault.provider.api.connection.parameters.TlsContext;
import com.avioconsulting.mule.vault.provider.internal.connection.VaultConnection;
import com.avioconsulting.mule.vault.provider.internal.connection.impl.TokenConnection;
import com.avioconsulting.mule.vault.provider.internal.connection.provider.AbstractConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisplayName(value="Token Connection")
@Alias(value="token-connection")
public class TokenConnectionProvider
extends AbstractConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(TokenConnectionProvider.class);
    @DisplayName(value="Vault Token")
    @Parameter
    private String vaultToken;
    @DisplayName(value="TLS Context")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Placement(tab="Security")
    @Parameter
    @Optional
    protected TlsContext tlsContext;

    public TokenConnectionProvider() {
    }

    public TokenConnectionProvider(ConfigurationParameters parameters) {
        super(parameters);
        this.tlsContext = new TlsContext(parameters);
        try {
            this.vaultToken = parameters.getStringParameter("vaultToken");
        }
        catch (Exception e) {
            logger.debug("vaultToken parameter is not present", (Throwable)e);
        }
    }

    @Override
    protected TlsContext getTlsContext() {
        return this.tlsContext;
    }

    public VaultConnection connect() throws ConnectionException {
        return new TokenConnection(this.vaultToken, this.getTlsContext());
    }
}

