/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.mockserver.internal;

import com.avioconsulting.mule.mockserver.api.mock.VerificationMethod;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mockserver.integration.ClientAndServer;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class MockServerConnection {
    private final String propertiesFilePath;
    private final Integer port;
    private ClientAndServer clientAndServer;
    private final HttpClient httpClient;
    private String baseUri;

    public MockServerConnection(String propertiesFilePath, Integer port, HttpClient httpClient) {
        this.propertiesFilePath = propertiesFilePath;
        this.port = port;
        this.httpClient = httpClient;
        this.init();
    }

    public void stop() {
        if (this.clientAndServer != null && this.clientAndServer.hasStarted()) {
            this.clientAndServer.stop();
        }
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }

    private void init() {
        Objects.requireNonNull(this.propertiesFilePath, "properties file path must not be null");
        System.setProperty("mockserver.propertyFile", this.propertiesFilePath);
        this.clientAndServer = ClientAndServer.startClientAndServer((Integer[])new Integer[]{this.port});
        boolean started = this.clientAndServer.hasStarted(5, 10L, TimeUnit.SECONDS);
        if (!started) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"MockServer did not start in time"));
        }
        this.httpClient.start();
        this.baseUri = String.format("%s://%s:%d", "http", "localhost", this.clientAndServer.getPort());
    }

    public void setExpectation(TypedValue<InputStream> expectation) {
        this.sendRequest(expectation, "/mockserver/expectation");
    }

    public void verifyExpectation(String expectationId, VerificationMethod method, Integer count) {
        this.clientAndServer.verify(expectationId, method.times(count));
    }

    public void clearExpectation(String expectationId) {
        this.clientAndServer.clear(expectationId);
    }

    public void resetExpectations() {
        this.clientAndServer.reset();
    }

    public void clearExpectation(TypedValue<InputStream> expectation) {
        this.sendRequest(expectation, "/mockserver/clear");
    }

    private void sendRequest(TypedValue<InputStream> expectation, String path) {
        Objects.requireNonNull(expectation);
        Objects.requireNonNull(expectation.getValue());
        InputStreamHttpEntity entity = new InputStreamHttpEntity((InputStream)expectation.getValue(), expectation.getByteLength());
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.PUT).uri(this.baseUri + path).protocol(HttpProtocol.HTTP_1_1).addHeader("Accepts", "application/json")).entity((HttpEntity)entity)).build();
        try {
            HttpResponse httpResponse = this.httpClient.send(request);
            switch (httpResponse.getStatusCode()) {
                case 400: {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Incorrect request format - %s", (Object[])new Object[]{httpResponse.getReasonPhrase()}));
                }
                case 406: {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Invalid expectation - %s", (Object[])new Object[]{httpResponse.getReasonPhrase()}));
                }
            }
        }
        catch (IOException | TimeoutException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public ConnectionValidationResult validate() {
        if (this.clientAndServer == null || !this.clientAndServer.hasStarted() || this.httpClient == null) {
            return ConnectionValidationResult.failure((String)"MockServer is not running", (Exception)new ConnectionException("MockServer is not running"));
        }
        return ConnectionValidationResult.success();
    }
}

