/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.mockserver.internal;

import com.avioconsulting.mule.mockserver.internal.MockServerConnection;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;

public class MockServerConnectionProvider
implements CachedConnectionProvider<MockServerConnection> {
    @Parameter
    @DisplayName(value="Mockserver Properties file")
    @Optional(defaultValue="mockserver.properties")
    private String propertiesFilePath;
    @Parameter
    @DisplayName(value="HTTP Port")
    private Integer port;
    @Inject
    private HttpService httpService;
    @RefName
    private String configName;

    public String getPropertiesFilePath() {
        return this.propertiesFilePath;
    }

    public MockServerConnectionProvider setPropertiesFilePath(String propertiesFilePath) {
        this.propertiesFilePath = propertiesFilePath;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public MockServerConnectionProvider setPort(Integer port) {
        this.port = port;
        return this;
    }

    public MockServerConnection connect() throws ConnectionException {
        HttpClientConfiguration clientConfiguration = new HttpClientConfiguration.Builder().setName(this.configName).build();
        HttpClient httpClient = this.httpService.getClientFactory().create(clientConfiguration);
        return new MockServerConnection(this.getPropertiesFilePath(), this.getPort(), httpClient);
    }

    public void disconnect(MockServerConnection connection) {
        connection.stop();
    }

    public ConnectionValidationResult validate(MockServerConnection connection) {
        return connection.validate();
    }
}

