/*
 * Decompiled with CFR 0.152.
 */
package com.avito.runner.service.worker.device.adb;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.avito.android.Problem;
import com.avito.android.ProblemKt;
import com.avito.android.Result;
import com.avito.cli.Notification;
import com.avito.cli.RxCommandLine;
import com.avito.logger.Logger;
import com.avito.runner.model.TestCaseRun;
import com.avito.runner.service.model.DeviceTestCaseRun;
import com.avito.runner.service.model.intention.InstrumentationTestRunAction;
import com.avito.runner.service.worker.device.Device;
import com.avito.runner.service.worker.device.DeviceCoordinate;
import com.avito.runner.service.worker.device.adb.Adb;
import com.avito.runner.service.worker.device.adb.AlwaysSuccessPullValidator;
import com.avito.runner.service.worker.device.adb.PullValidator;
import com.avito.runner.service.worker.device.adb.RetryAction;
import com.avito.runner.service.worker.device.adb.instrumentation.InstrumentationTestCaseRunParser;
import com.avito.runner.service.worker.device.adb.listener.AdbDeviceEventsListener;
import com.avito.runner.service.worker.device.adb.request.AdbRequest;
import com.avito.runner.service.worker.device.adb.request.adb.LogcatAdbRequest;
import com.avito.runner.service.worker.device.adb.request.adb.PullAdbRequest;
import com.avito.runner.service.worker.device.adb.request.shell.ClearDirectoryAdbShellRequest;
import com.avito.runner.service.worker.device.adb.request.shell.ClearPackageAdbShellRequest;
import com.avito.runner.service.worker.device.adb.request.shell.GetPropAdbShellRequest;
import com.avito.runner.service.worker.device.adb.request.shell.ListDirectoryAdbShellRequest;
import com.avito.runner.service.worker.device.adb.request.shell.RunTestsAdbShellRequest;
import com.avito.runner.service.worker.device.model.DeviceDataKt;
import com.avito.runner.service.worker.model.DeviceInstallation;
import com.avito.runner.service.worker.model.Installation;
import com.avito.runner.service.worker.model.InstrumentationTestCaseRun;
import com.avito.test.model.TestCase;
import com.avito.time.TimeProvider;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rx.Observable;
import rx.Single;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010)\u001a\u00020\u0005H\u0016J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0007H\u00c6\u0003J\t\u0010-\u001a\u00020\tH\u00c6\u0003J\t\u0010.\u001a\u00020\u000bH\u00c2\u0003J\t\u0010/\u001a\u00020\rH\u00c2\u0003J\t\u00100\u001a\u00020\u000fH\u00c6\u0003J\t\u00101\u001a\u00020\u0011H\u00c2\u0003J\t\u00102\u001a\u00020\u0013H\u00c2\u0003Jc\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u00c6\u0001J\b\u00104\u001a\u000205H\u0016J\u0013\u00106\u001a\u00020\u00072\b\u00107\u001a\u0004\u0018\u000108H\u00d6\u0003J\"\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u0010<\u001a\u00020=2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0002J\u001a\u0010@\u001a\u00020A2\u0006\u0010<\u001a\u00020=2\b\b\u0002\u0010B\u001a\u00020CH\u0002J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020E0$H\u0002J\t\u0010F\u001a\u00020\tH\u00d6\u0001J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020H0$2\u0006\u0010I\u001a\u00020\u0005H\u0016J\u001c\u0010J\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050K0$2\u0006\u0010&\u001a\u00020'H\u0016JC\u0010L\u001a\u0002HM\"\u0006\b\u0000\u0010M\u0018\u00012\u0006\u0010N\u001a\u00020\u00052#\b\u0004\u0010O\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\bQ\u0012\b\b)\u0012\u0004\b\b(R\u0012\u0004\u0012\u0002HM0PH\u0082\b\u00a2\u0006\u0002\u0010SJ\u001d\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00050$2\b\u0010U\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010VJ\u001e\u0010W\u001a\b\u0012\u0004\u0012\u00020?0$2\u0006\u0010X\u001a\u00020'2\u0006\u0010Y\u001a\u00020'H\u0016J&\u0010Z\u001a\b\u0012\u0004\u0012\u00020?0$2\u0006\u0010[\u001a\u00020'2\u0006\u0010\\\u001a\u00020'2\u0006\u0010]\u001a\u00020^H\u0016J&\u0010_\u001a\b\u0012\u0004\u0012\u00020?0$2\u0006\u0010`\u001a\u00020'2\u0006\u0010\\\u001a\u00020'2\u0006\u0010]\u001a\u00020^H\u0016J&\u0010a\u001a\b\u0012\u0004\u0012\u00020?0$2\u0006\u0010X\u001a\u00020'2\u0006\u0010Y\u001a\u00020'2\u0006\u0010]\u001a\u00020^H\u0002J!\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020?H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010gJR\u0010h\u001a\b\u0012\u0004\u0012\u00020j0i2\u0006\u0010k\u001a\u00020l2\u0006\u0010m\u001a\u00020\u00052\u0006\u0010n\u001a\u00020\u00052\u0012\u0010o\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050p2\u0006\u0010f\u001a\u00020?2\u0006\u0010q\u001a\u00020C2\u0006\u0010r\u001a\u00020\u0007H\u0002J\b\u0010s\u001a\u00020\u0005H\u0016J\u001a\u0010t\u001a\u00020%2\u0006\u0010\n\u001a\u00020u2\b\b\u0002\u0010v\u001a\u00020\u0013H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006w"}, d2={"Lcom/avito/runner/service/worker/device/adb/AdbDevice;", "Lcom/avito/runner/service/worker/device/Device;", "coordinate", "Lcom/avito/runner/service/worker/device/DeviceCoordinate;", "model", "", "online", "", "api", "", "adb", "Lcom/avito/runner/service/worker/device/adb/Adb;", "timeProvider", "Lcom/avito/time/TimeProvider;", "logger", "Lcom/avito/logger/Logger;", "eventsListener", "Lcom/avito/runner/service/worker/device/adb/listener/AdbDeviceEventsListener;", "adbPullTimeout", "Ljava/time/Duration;", "(Lcom/avito/runner/service/worker/device/DeviceCoordinate;Ljava/lang/String;ZILcom/avito/runner/service/worker/device/adb/Adb;Lcom/avito/time/TimeProvider;Lcom/avito/logger/Logger;Lcom/avito/runner/service/worker/device/adb/listener/AdbDeviceEventsListener;Ljava/time/Duration;)V", "getApi", "()I", "getCoordinate", "()Lcom/avito/runner/service/worker/device/DeviceCoordinate;", "instrumentationParser", "Lcom/avito/runner/service/worker/device/adb/instrumentation/InstrumentationTestCaseRunParser;", "getLogger", "()Lcom/avito/logger/Logger;", "getModel", "()Ljava/lang/String;", "getOnline", "()Z", "retryAction", "Lcom/avito/runner/service/worker/device/adb/RetryAction;", "clearDirectory", "Lcom/avito/android/Result;", "", "remotePath", "Ljava/nio/file/Path;", "clearPackage", "name", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "deviceStatus", "Lcom/avito/runner/service/worker/device/Device$DeviceStatus;", "equals", "other", "", "executeAdbRequest", "Lrx/Observable;", "Lcom/avito/cli/Notification;", "request", "Lcom/avito/runner/service/worker/device/adb/request/AdbRequest;", "redirectOutputTo", "Ljava/io/File;", "executeBlockingAdbRequest", "Lcom/avito/cli/Notification$Exit;", "timeoutSeconds", "", "getAdbDevice", "Lcom/android/ddmlib/IDevice;", "hashCode", "installApplication", "Lcom/avito/runner/service/worker/model/DeviceInstallation;", "applicationPackage", "list", "", "loadProperty", "T", "key", "cast", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "result", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "logcat", "lines", "(Ljava/lang/Integer;)Lcom/avito/android/Result;", "pull", "from", "to", "pullDir", "deviceDir", "hostDir", "validator", "Lcom/avito/runner/service/worker/device/adb/PullValidator;", "pullFile", "deviceFile", "pullInternal", "runIsolatedTest", "Lcom/avito/runner/service/model/DeviceTestCaseRun;", "action", "Lcom/avito/runner/service/model/intention/InstrumentationTestRunAction;", "outputDir", "(Lcom/avito/runner/service/model/intention/InstrumentationTestRunAction;Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runTest", "Lrx/Single;", "Lcom/avito/runner/service/worker/model/InstrumentationTestCaseRun;", "test", "Lcom/avito/test/model/TestCase;", "testPackageName", "testRunnerClass", "instrumentationArguments", "", "timeoutMinutes", "enableDeviceDebug", "toString", "waitForAdb", "Lcom/android/ddmlib/AndroidDebugBridge;", "timeOut", "service"})
public final class AdbDevice
implements Device {
    @NotNull
    private final DeviceCoordinate coordinate;
    @NotNull
    private final String model;
    private final boolean online;
    private final int api;
    @NotNull
    private final Adb adb;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AdbDeviceEventsListener eventsListener;
    @NotNull
    private final Duration adbPullTimeout;
    @NotNull
    private final InstrumentationTestCaseRunParser instrumentationParser;
    @NotNull
    private final RetryAction retryAction;

    public AdbDevice(@NotNull DeviceCoordinate coordinate, @NotNull String model, boolean online, int api, @NotNull Adb adb, @NotNull TimeProvider timeProvider, @NotNull Logger logger, @NotNull AdbDeviceEventsListener eventsListener, @NotNull Duration adbPullTimeout) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)adb, (String)"adb");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)eventsListener, (String)"eventsListener");
        Intrinsics.checkNotNullParameter((Object)adbPullTimeout, (String)"adbPullTimeout");
        this.coordinate = coordinate;
        this.model = model;
        this.online = online;
        this.api = api;
        this.adb = adb;
        this.timeProvider = timeProvider;
        this.logger = logger;
        this.eventsListener = eventsListener;
        this.adbPullTimeout = adbPullTimeout;
        this.instrumentationParser = new InstrumentationTestCaseRunParser.Impl();
        this.retryAction = new RetryAction(this.timeProvider);
    }

    @Override
    @NotNull
    public DeviceCoordinate getCoordinate() {
        return this.coordinate;
    }

    @Override
    @NotNull
    public String getModel() {
        return this.model;
    }

    @Override
    public boolean getOnline() {
        return this.online;
    }

    @Override
    public int getApi() {
        return this.api;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result<DeviceInstallation> installApplication(@NotNull String applicationPackage) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)applicationPackage, (String)"applicationPackage");
        long installStartedTimestamp = 0L;
        Result<IDevice> this_$iv = this.getAdbDevice();
        boolean $i$f$flatMap = false;
        Result<IDevice> result2 = this_$iv;
        if (result2 instanceof Result.Success) {
            Result result3;
            try {
                Result result4;
                void this_$iv2;
                IDevice adbDevice = (IDevice)((Result.Success)this_$iv).getValue();
                boolean bl = false;
                installStartedTimestamp = this.timeProvider.nowInMillis();
                Result result5 = this.retryAction.retry(10, 5L, (Function3<? super Integer, ? super Throwable, ? super Long, Unit>)((Function3)new Function3<Integer, Throwable, Long, Unit>(this, applicationPackage){
                    final /* synthetic */ AdbDevice this$0;
                    final /* synthetic */ String $applicationPackage;
                    {
                        this.this$0 = $receiver;
                        this.$applicationPackage = $applicationPackage;
                        super(3);
                    }

                    public final void invoke(int attempt, @NotNull Throwable throwable, long durationMs) {
                        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                        AdbDevice.access$getEventsListener$p(this.this$0).onInstallApplicationError(this.this$0, attempt, this.$applicationPackage, throwable, durationMs);
                    }
                }), (Function2<? super Throwable, ? super Long, Unit>)((Function2)new Function2<Throwable, Long, Unit>(this, applicationPackage){
                    final /* synthetic */ AdbDevice this$0;
                    final /* synthetic */ String $applicationPackage;
                    {
                        this.this$0 = $receiver;
                        this.$applicationPackage = $applicationPackage;
                        super(2);
                    }

                    public final void invoke(@NotNull Throwable throwable, long durationMs) {
                        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                        AdbDevice.access$getEventsListener$p(this.this$0).onInstallApplicationFailure(this.this$0, this.$applicationPackage, throwable, durationMs);
                    }
                }), (Function3)new Function3<Integer, Unit, Long, Unit>(this, applicationPackage){
                    final /* synthetic */ AdbDevice this$0;
                    final /* synthetic */ String $applicationPackage;
                    {
                        this.this$0 = $receiver;
                        this.$applicationPackage = $applicationPackage;
                        super(3);
                    }

                    public final void invoke(int attempt, @NotNull Unit unit, long durationMs) {
                        Intrinsics.checkNotNullParameter((Object)unit, (String)"<anonymous parameter 1>");
                        AdbDevice.access$getEventsListener$p(this.this$0).onInstallApplicationSuccess(this.this$0, attempt, this.$applicationPackage, durationMs);
                    }
                }, (Function0)new Function0<Unit>(adbDevice, applicationPackage){
                    final /* synthetic */ IDevice $adbDevice;
                    final /* synthetic */ String $applicationPackage;
                    {
                        this.$adbDevice = $adbDevice;
                        this.$applicationPackage = $applicationPackage;
                        super(0);
                    }

                    public final void invoke() {
                        this.$adbDevice.installPackage(this.$applicationPackage, true, new String[0]);
                    }
                });
                boolean $i$f$map = false;
                void var9_10 = this_$iv2;
                if (var9_10 instanceof Result.Success) {
                    Result result6;
                    try {
                        Unit it = (Unit)((Result.Success)this_$iv2).getValue();
                        boolean bl2 = false;
                        DeviceInstallation deviceInstallation = new DeviceInstallation(new Installation(applicationPackage, installStartedTimestamp, this.timeProvider.nowInMillis()), DeviceDataKt.getData(this));
                        result6 = (Result)new Result.Success((Object)deviceInstallation);
                    }
                    catch (Throwable throwable$iv) {
                        result6 = (Result)new Result.Failure(throwable$iv);
                    }
                    result4 = result6;
                } else if (var9_10 instanceof Result.Failure) {
                    result4 = (Result)new Result.Failure(((Result.Failure)this_$iv2).getThrowable());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                result3 = result4;
            }
            catch (Throwable e$iv) {
                result3 = (Result)new Result.Failure(e$iv);
            }
            result = result3;
        } else if (result2 instanceof Result.Failure) {
            result = (Result)new Result.Failure(((Result.Failure)this_$iv).getThrowable());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    @Override
    @Nullable
    public Object runIsolatedTest(@NotNull InstrumentationTestRunAction action, @NotNull File outputDir, @NotNull Continuation<? super DeviceTestCaseRun> $completion) {
        Map finalInstrumentationArguments = MapsKt.plus(action.getInstrumentationParams(), (Pair)TuplesKt.to((Object)"class", (Object)(action.getTest().getName().getClassName() + '#' + action.getTest().getName().getMethodName())));
        long startTime = this.timeProvider.nowInMillis();
        Object object = this.runTest(action.getTest(), action.getTestPackage(), action.getTestRunner(), finalInstrumentationArguments, outputDir, action.getTimeoutMinutes(), action.getEnableDeviceDebug()).map(arg_0 -> AdbDevice.runIsolatedTest$lambda-2(this, startTime, action, arg_0)).toBlocking().value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runTest(\n            tes\u2026ng()\n            .value()");
        return object;
    }

    @Override
    @NotNull
    public Device.DeviceStatus deviceStatus() {
        Device.DeviceStatus deviceStatus2;
        Result this_$iv = this.retryAction.retry(15, 5L, (Function3<? super Integer, ? super Throwable, ? super Long, Unit>)((Function3)new Function3<Integer, Throwable, Long, Unit>(this){
            final /* synthetic */ AdbDevice this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(int attempt, @NotNull Throwable throwable, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"<anonymous parameter 1>");
                AdbDevice.access$getEventsListener$p(this.this$0).onGetAliveDeviceError(this.this$0, attempt, durationMs);
            }
        }), (Function2<? super Throwable, ? super Long, Unit>)((Function2)new Function2<Throwable, Long, Unit>(this){
            final /* synthetic */ AdbDevice this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Throwable throwable, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                AdbDevice.access$getEventsListener$p(this.this$0).onGetAliveDeviceFailed(this.this$0, throwable, durationMs);
            }
        }), (Function3)new Function3<Integer, Boolean, Long, Unit>(this){
            final /* synthetic */ AdbDevice this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(int attempt, boolean bl, long durationMs) {
                AdbDevice.access$getEventsListener$p(this.this$0).onGetAliveDeviceSuccess(this.this$0, attempt, durationMs);
            }
        }, (Function0)new Function0<Boolean>(this){
            final /* synthetic */ AdbDevice this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                void this_$iv;
                AdbDevice adbDevice = this.this$0;
                String key$iv = "sys.boot_completed";
                boolean $i$f$loadProperty = false;
                Notification.Exit commandResult$iv = AdbDevice.executeBlockingAdbRequest$default((AdbDevice)this_$iv, new GetPropAdbShellRequest(key$iv), 0L, 2, null);
                String output$iv = ((Object)StringsKt.trim((CharSequence)commandResult$iv.getOutput())).toString();
                try {
                    String output = output$iv;
                    boolean bl2 = false;
                    bl = Intrinsics.areEqual((Object)output, (Object)"1");
                }
                catch (Exception e$iv) {
                    throw new RuntimeException("Failed to cast property result with key: " + key$iv + ". Output: " + output$iv + '.');
                }
                boolean bootCompleted = bl;
                if (!bootCompleted) {
                    throw new IllegalStateException("sys.boot_completed isn't '1'");
                }
                return bootCompleted;
            }
        });
        boolean $i$f$fold = false;
        Result result = this_$iv;
        if (result instanceof Result.Success) {
            boolean it = (Boolean)((Result.Success)this_$iv).getValue();
            boolean bl = false;
            deviceStatus2 = Device.DeviceStatus.Alive.INSTANCE;
        } else if (result instanceof Result.Failure) {
            Throwable throwable = ((Result.Failure)this_$iv).getThrowable();
            boolean bl = false;
            deviceStatus2 = new Device.DeviceStatus.Freeze(throwable);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return deviceStatus2;
    }

    @Override
    @NotNull
    public Result<Unit> clearPackage(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.retryAction.retry(10, 1L, (Function3<? super Integer, ? super Throwable, ? super Long, Unit>)((Function3)new Function3<Integer, Throwable, Long, Unit>(this, name){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(3);
            }

            public final void invoke(int attempt, @NotNull Throwable throwable, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                AdbDevice.access$getEventsListener$p(this.this$0).onClearPackageError(this.this$0, attempt, this.$name, throwable, durationMs);
            }
        }), (Function2<? super Throwable, ? super Long, Unit>)((Function2)new Function2<Throwable, Long, Unit>(this, name){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(2);
            }

            public final void invoke(@NotNull Throwable throwable, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                AdbDevice.access$getEventsListener$p(this.this$0).onClearPackageFailure(this.this$0, this.$name, throwable, durationMs);
            }
        }), (Function3)new Function3<Integer, Object, Long, Unit>(this, name){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(3);
            }

            public final void invoke(int attempt, @NotNull Object object, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"<anonymous parameter 1>");
                AdbDevice.access$getEventsListener$p(this.this$0).onClearPackageSuccess(this.this$0, attempt, this.$name, durationMs);
            }
        }, (Function0)new Function0<Unit>(this, name){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(0);
            }

            public final void invoke() {
                Notification.Exit result = AdbDevice.access$executeBlockingAdbRequest(this.this$0, new ClearPackageAdbShellRequest(this.$name), 20L);
                if (!StringsKt.contains((CharSequence)result.getOutput(), (CharSequence)"success", (boolean)true)) {
                    throw new IllegalStateException("Fail to clear package " + this.$name + "; output=" + result.getOutput());
                }
            }
        });
    }

    @Override
    @NotNull
    public Result<File> pull(@NotNull Path from, @NotNull Path to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return this.pullInternal(from, to, AlwaysSuccessPullValidator.INSTANCE);
    }

    @Override
    @NotNull
    public Result<File> pullDir(@NotNull Path deviceDir, @NotNull Path hostDir, @NotNull PullValidator validator) {
        Intrinsics.checkNotNullParameter((Object)deviceDir, (String)"deviceDir");
        Intrinsics.checkNotNullParameter((Object)hostDir, (String)"hostDir");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Path path = deviceDir.resolve(".");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
        return this.pullInternal(path, hostDir, validator);
    }

    @Override
    @NotNull
    public Result<File> pullFile(@NotNull Path deviceFile, @NotNull Path hostDir, @NotNull PullValidator validator) {
        Intrinsics.checkNotNullParameter((Object)deviceFile, (String)"deviceFile");
        Intrinsics.checkNotNullParameter((Object)hostDir, (String)"hostDir");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        return this.pullInternal(deviceFile, hostDir, validator);
    }

    @Override
    @NotNull
    public Result<Unit> clearDirectory(@NotNull Path remotePath) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        Result this_$iv = this.retryAction.retry(5, 3L, (Function3<? super Integer, ? super Throwable, ? super Long, Unit>)((Function3)new Function3<Integer, Throwable, Long, Unit>(this, remotePath){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ Path $remotePath;
            {
                this.this$0 = $receiver;
                this.$remotePath = $remotePath;
                super(3);
            }

            public final void invoke(int attempt, @NotNull Throwable throwable, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                AdbDevice.access$getEventsListener$p(this.this$0).onClearDirectoryError(this.this$0, attempt, this.$remotePath, throwable, durationMs);
            }
        }), (Function2<? super Throwable, ? super Long, Unit>)((Function2)new Function2<Throwable, Long, Unit>(this, remotePath){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ Path $remotePath;
            {
                this.this$0 = $receiver;
                this.$remotePath = $remotePath;
                super(2);
            }

            public final void invoke(@NotNull Throwable throwable, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                AdbDevice.access$getEventsListener$p(this.this$0).onClearDirectoryFailure(this.this$0, this.$remotePath, throwable, durationMs);
            }
        }), (Function3)new Function3<Integer, Notification.Exit, Long, Unit>(this, remotePath){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ Path $remotePath;
            {
                this.this$0 = $receiver;
                this.$remotePath = $remotePath;
                super(3);
            }

            public final void invoke(int n, @NotNull Notification.Exit result, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                AdbDevice.access$getEventsListener$p(this.this$0).onClearDirectorySuccess(this.this$0, this.$remotePath, result.getOutput(), durationMs);
            }
        }, (Function0)new Function0<Notification.Exit>(this, remotePath){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ Path $remotePath;
            {
                this.this$0 = $receiver;
                this.$remotePath = $remotePath;
                super(0);
            }

            @NotNull
            public final Notification.Exit invoke() {
                return AdbDevice.executeBlockingAdbRequest$default(this.this$0, new ClearDirectoryAdbShellRequest(this.$remotePath), 0L, 2, null);
            }
        });
        boolean $i$f$map = false;
        Result result2 = this_$iv;
        if (result2 instanceof Result.Success) {
            Result result3;
            try {
                Notification.Exit it = (Notification.Exit)((Result.Success)this_$iv).getValue();
                boolean bl = false;
                Unit unit = Unit.INSTANCE;
                result3 = (Result)new Result.Success((Object)unit);
            }
            catch (Throwable throwable$iv) {
                result3 = (Result)new Result.Failure(throwable$iv);
            }
            result = result3;
        } else if (result2 instanceof Result.Failure) {
            result = (Result)new Result.Failure(((Result.Failure)this_$iv).getThrowable());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    @Override
    @NotNull
    public Result<List<String>> list(@NotNull Path remotePath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        return this.retryAction.retry(5, 3L, (Function3<? super Integer, ? super Throwable, ? super Long, Unit>)((Function3)new Function3<Integer, Throwable, Long, Unit>(this, remotePath){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ Path $remotePath;
            {
                this.this$0 = $receiver;
                this.$remotePath = $remotePath;
                super(3);
            }

            public final void invoke(int attempt, @NotNull Throwable throwable, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                AdbDevice.access$getEventsListener$p(this.this$0).onListError(this.this$0, attempt, ((Object)this.$remotePath).toString(), throwable, durationMs);
            }
        }), (Function2<? super Throwable, ? super Long, Unit>)((Function2)new Function2<Throwable, Long, Unit>(this, remotePath){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ Path $remotePath;
            {
                this.this$0 = $receiver;
                this.$remotePath = $remotePath;
                super(2);
            }

            public final void invoke(@NotNull Throwable throwable, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                AdbDevice.access$getEventsListener$p(this.this$0).onListFailure(this.this$0, ((Object)this.$remotePath).toString(), throwable, durationMs);
            }
        }), (Function3)new Function3<Integer, List<? extends String>, Long, Unit>(this, remotePath){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ Path $remotePath;
            {
                this.this$0 = $receiver;
                this.$remotePath = $remotePath;
                super(3);
            }

            public final void invoke(int n, @NotNull List<String> list2, long durationMs) {
                Intrinsics.checkNotNullParameter(list2, (String)"<anonymous parameter 1>");
                AdbDevice.access$getEventsListener$p(this.this$0).onListSuccess(this.this$0, ((Object)this.$remotePath).toString(), durationMs);
            }
        }, (Function0)new Function0<List<? extends String>>(this, remotePath){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ Path $remotePath;
            {
                this.this$0 = $receiver;
                this.$remotePath = $remotePath;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                return StringsKt.lines((CharSequence)AdbDevice.executeBlockingAdbRequest$default(this.this$0, new ListDirectoryAdbShellRequest(this.$remotePath), 0L, 2, null).getOutput());
            }
        });
    }

    private final Result<File> pullInternal(Path from, Path to, PullValidator validator) {
        return this.retryAction.retry(5, 3L, (Function3<? super Integer, ? super Throwable, ? super Long, Unit>)((Function3)new Function3<Integer, Throwable, Long, Unit>(this, from){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ Path $from;
            {
                this.this$0 = $receiver;
                this.$from = $from;
                super(3);
            }

            public final void invoke(int attempt, @NotNull Throwable throwable, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                AdbDevice.access$getEventsListener$p(this.this$0).onPullError(this.this$0, attempt, this.$from, throwable, durationMs);
            }
        }), (Function2<? super Throwable, ? super Long, Unit>)((Function2)new Function2<Throwable, Long, Unit>(this, from){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ Path $from;
            {
                this.this$0 = $receiver;
                this.$from = $from;
                super(2);
            }

            public final void invoke(@NotNull Throwable throwable, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                AdbDevice.access$getEventsListener$p(this.this$0).onPullFailure(this.this$0, this.$from, throwable, durationMs);
            }
        }), (Function3)new Function3<Integer, Object, Long, Unit>(this, from, to){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ Path $from;
            final /* synthetic */ Path $to;
            {
                this.this$0 = $receiver;
                this.$from = $from;
                this.$to = $to;
                super(3);
            }

            public final void invoke(int n, @NotNull Object object, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"<anonymous parameter 1>");
                AdbDevice.access$getEventsListener$p(this.this$0).onPullSuccess(this.this$0, this.$from, this.$to, durationMs);
            }
        }, (Function0)new Function0<File>(this, from, to, validator){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ Path $from;
            final /* synthetic */ Path $to;
            final /* synthetic */ PullValidator $validator;
            {
                this.this$0 = $receiver;
                this.$from = $from;
                this.$to = $to;
                this.$validator = $validator;
                super(0);
            }

            @NotNull
            public final File invoke() {
                AdbDevice.access$executeBlockingAdbRequest(this.this$0, new PullAdbRequest(this.$from, this.$to), AdbDevice.access$getAdbPullTimeout$p(this.this$0).toSeconds());
                PullValidator.Result pullResult = this.$validator.isPulledCompletely(this.$to);
                if (!(pullResult instanceof PullValidator.Result.Ok)) {
                    if (pullResult instanceof PullValidator.Result.Failure) {
                        throw ProblemKt.asRuntimeException((Problem)((PullValidator.Result.Failure)pullResult).getProblem());
                    }
                    throw new NoWhenBranchMatchedException();
                }
                File file = this.$to.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"when (val pullResult = v\u2026Exception()\n            }");
                return file;
            }
        });
    }

    @Override
    @NotNull
    public Result<String> logcat(@Nullable Integer lines) {
        return this.retryAction.retry(3, 1L, (Function3<? super Integer, ? super Throwable, ? super Long, Unit>)((Function3)new Function3<Integer, Throwable, Long, Unit>(this){
            final /* synthetic */ AdbDevice this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(int n, @NotNull Throwable throwable, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                AdbDevice.access$getEventsListener$p(this.this$0).onLogcatError(this.this$0, durationMs, throwable);
            }
        }), (Function2<? super Throwable, ? super Long, Unit>)((Function2)new Function2<Throwable, Long, Unit>(this){
            final /* synthetic */ AdbDevice this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Throwable throwable, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                AdbDevice.access$getEventsListener$p(this.this$0).onLogcatFailure(this.this$0, durationMs, throwable);
            }
        }), (Function3)new Function3<Integer, String, Long, Unit>(this){
            final /* synthetic */ AdbDevice this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(int n, @NotNull String string, long durationMs) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 1>");
                AdbDevice.access$getEventsListener$p(this.this$0).onLogcatSuccess(this.this$0, durationMs);
            }
        }, (Function0)new Function0<String>(this, lines){
            final /* synthetic */ AdbDevice this$0;
            final /* synthetic */ Integer $lines;
            {
                this.this$0 = $receiver;
                this.$lines = $lines;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return AdbDevice.access$executeBlockingAdbRequest(this.this$0, new LogcatAdbRequest(this.$lines), 10L).getOutput();
            }
        });
    }

    private final Single<InstrumentationTestCaseRun> runTest(TestCase test, String testPackageName, String testRunnerClass, Map<String, String> instrumentationArguments, File outputDir, long timeoutMinutes, boolean enableDeviceDebug) {
        File file;
        File $this$runTest_u24lambda_u2d6 = file = new File(new File(outputDir, "logs"), this.getCoordinate().getSerial().getValue());
        boolean bl = false;
        $this$runTest_u24lambda_u2d6.mkdirs();
        File logsDir = file;
        long started = this.timeProvider.nowInMillis();
        Map<String, String> $this$filterValues$iv = instrumentationArguments;
        boolean $i$f$filterValues = false;
        LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry$iv : $this$filterValues$iv.entrySet()) {
            String it = entry$iv.getValue();
            boolean bl2 = false;
            if (!StringsKt.isBlank((CharSequence)it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map blankValues = result$iv;
        if (!blankValues.isEmpty()) {
            Single single = Single.error((Throwable)new IllegalArgumentException("Instrumentation args contains blank values: " + blankValues + " it leads to adb args parsing problem. Filter it in configuration"));
            Intrinsics.checkNotNullExpressionValue((Object)single, (String)"error(\n                I\u2026          )\n            )");
            return single;
        }
        Observable output = this.executeAdbRequest(new RunTestsAdbShellRequest(testPackageName, testRunnerClass, instrumentationArguments, enableDeviceDebug), new File(logsDir, "instrumentation-" + test.getName() + ".txt")).ofType(Notification.Output.class);
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
        Single single = this.instrumentationParser.parse((Observable<Notification.Output>)output).timeout(timeoutMinutes, TimeUnit.MINUTES, Observable.just((Object)new InstrumentationTestCaseRun.CompletedTestCaseRun(test.getName(), (TestCaseRun.Result)new TestCaseRun.Result.Failed.InfrastructureError.Timeout(timeoutMinutes, (Throwable)new RuntimeException("Failed on Timeout")), started, started + TimeUnit.MINUTES.toMillis(timeoutMinutes)))).first().toSingle();
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"instrumentationParser\n  \u2026)\n            .toSingle()");
        return single;
    }

    private final Result<IDevice> getAdbDevice() {
        Result result;
        Result.Companion this_$iv = Result.Companion;
        boolean $i$f$tryCatch = false;
        try {
            Object object;
            block4: {
                boolean bl = false;
                AndroidDebugBridge.initIfNeeded((boolean)false);
                DdmPreferences.setTimeOut((int)((int)Duration.ofSeconds(20L).toMillis()));
                AndroidDebugBridge bridge = AndroidDebugBridge.createBridge((String)this.adb.getAdbPath(), (boolean)false);
                Intrinsics.checkNotNullExpressionValue((Object)bridge, (String)"bridge");
                AdbDevice.waitForAdb$default(this, bridge, null, 2, null);
                IDevice[] iDeviceArray = bridge.getDevices();
                Intrinsics.checkNotNullExpressionValue((Object)iDeviceArray, (String)"bridge.devices");
                for (Object object2 : (Object[])iDeviceArray) {
                    IDevice it = (IDevice)object2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getSerialNumber(), (Object)this.getCoordinate().getSerial().getValue())) continue;
                    object = object2;
                    break block4;
                }
                object = null;
            }
            IDevice iDevice = (IDevice)object;
            if (iDevice == null) {
                throw new RuntimeException("Device " + this.getCoordinate() + " not found");
            }
            IDevice iDevice2 = iDevice;
            result = (Result)new Result.Success((Object)iDevice2);
        }
        catch (Throwable e$iv) {
            result = (Result)new Result.Failure(e$iv);
        }
        return result;
    }

    private final void waitForAdb(AndroidDebugBridge adb, Duration timeOut) {
        long timeOutMs;
        long sleepTimeMs = TimeUnit.SECONDS.toMillis(1L);
        for (timeOutMs = timeOut.toMillis(); !adb.hasInitialDeviceList() && timeOutMs > 0L; timeOutMs -= sleepTimeMs) {
            try {
                Thread.sleep(sleepTimeMs);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (timeOutMs <= 0L && !adb.hasInitialDeviceList()) {
            throw new RuntimeException("Timeout getting device list.", null);
        }
    }

    static /* synthetic */ void waitForAdb$default(AdbDevice adbDevice, AndroidDebugBridge androidDebugBridge, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(WAIT_FOR_ADB_TIME_OUT_MINUTES)");
            duration = duration2;
        }
        adbDevice.waitForAdb(androidDebugBridge, duration);
    }

    private final /* synthetic */ <T> T loadProperty(String key, Function1<? super String, ? extends T> cast) {
        Object object;
        boolean $i$f$loadProperty = false;
        Notification.Exit commandResult = AdbDevice.executeBlockingAdbRequest$default(this, new GetPropAdbShellRequest(key), 0L, 2, null);
        String output = ((Object)StringsKt.trim((CharSequence)commandResult.getOutput())).toString();
        try {
            object = cast.invoke((Object)output);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to cast property result with key: " + key + ". Output: " + output + '.');
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    private final Notification.Exit executeBlockingAdbRequest(AdbRequest request, long timeoutSeconds) {
        void $this$executeBlockingAdbRequest_u24lambda_u2d10;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        TimeUnit timeUnit = TimeUnit.SECONDS;
        long l = timeoutSeconds;
        Observable observable = AdbDevice.executeAdbRequest$default(this, request, null, 2, null).ofType(Notification.Exit.class);
        boolean bl = false;
        $this$executeBlockingAdbRequest_u24lambda_u2d10.append("Timeout: " + timeoutSeconds + " seconds. ");
        $this$executeBlockingAdbRequest_u24lambda_u2d10.append("Failed to execute command: " + request.serialize(this.getCoordinate().getSerial().getValue()) + ' ');
        $this$executeBlockingAdbRequest_u24lambda_u2d10.append("on device " + this.getCoordinate());
        Unit unit = Unit.INSTANCE;
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String string2 = string;
        Object object = observable.timeout(l, timeUnit, Observable.error((Throwable)new RuntimeException(string2))).toBlocking().first();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeAdbRequest(reques\u2026ng()\n            .first()");
        return (Notification.Exit)object;
    }

    static /* synthetic */ Notification.Exit executeBlockingAdbRequest$default(AdbDevice adbDevice, AdbRequest adbRequest, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 5L;
        }
        return adbDevice.executeBlockingAdbRequest(adbRequest, l);
    }

    private final Observable<Notification> executeAdbRequest(AdbRequest request, File redirectOutputTo) {
        return new RxCommandLine(this.adb.getAdbPath(), request.serialize(this.getCoordinate().getSerial().getValue())).start(redirectOutputTo);
    }

    static /* synthetic */ Observable executeAdbRequest$default(AdbDevice adbDevice, AdbRequest adbRequest, File file, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        return adbDevice.executeAdbRequest(adbRequest, file);
    }

    @NotNull
    public String toString() {
        return "Device " + this.getCoordinate().getSerial();
    }

    @NotNull
    public final DeviceCoordinate component1() {
        return this.getCoordinate();
    }

    @NotNull
    public final String component2() {
        return this.getModel();
    }

    public final boolean component3() {
        return this.getOnline();
    }

    public final int component4() {
        return this.getApi();
    }

    private final Adb component5() {
        return this.adb;
    }

    private final TimeProvider component6() {
        return this.timeProvider;
    }

    @NotNull
    public final Logger component7() {
        return this.getLogger();
    }

    private final AdbDeviceEventsListener component8() {
        return this.eventsListener;
    }

    private final Duration component9() {
        return this.adbPullTimeout;
    }

    @NotNull
    public final AdbDevice copy(@NotNull DeviceCoordinate coordinate, @NotNull String model, boolean online, int api, @NotNull Adb adb, @NotNull TimeProvider timeProvider, @NotNull Logger logger, @NotNull AdbDeviceEventsListener eventsListener, @NotNull Duration adbPullTimeout) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)adb, (String)"adb");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)eventsListener, (String)"eventsListener");
        Intrinsics.checkNotNullParameter((Object)adbPullTimeout, (String)"adbPullTimeout");
        return new AdbDevice(coordinate, model, online, api, adb, timeProvider, logger, eventsListener, adbPullTimeout);
    }

    public static /* synthetic */ AdbDevice copy$default(AdbDevice adbDevice, DeviceCoordinate deviceCoordinate, String string, boolean bl, int n, Adb adb, TimeProvider timeProvider, Logger logger, AdbDeviceEventsListener adbDeviceEventsListener, Duration duration, int n2, Object object) {
        if ((n2 & 1) != 0) {
            deviceCoordinate = adbDevice.getCoordinate();
        }
        if ((n2 & 2) != 0) {
            string = adbDevice.getModel();
        }
        if ((n2 & 4) != 0) {
            bl = adbDevice.getOnline();
        }
        if ((n2 & 8) != 0) {
            n = adbDevice.getApi();
        }
        if ((n2 & 0x10) != 0) {
            adb = adbDevice.adb;
        }
        if ((n2 & 0x20) != 0) {
            timeProvider = adbDevice.timeProvider;
        }
        if ((n2 & 0x40) != 0) {
            logger = adbDevice.getLogger();
        }
        if ((n2 & 0x80) != 0) {
            adbDeviceEventsListener = adbDevice.eventsListener;
        }
        if ((n2 & 0x100) != 0) {
            duration = adbDevice.adbPullTimeout;
        }
        return adbDevice.copy(deviceCoordinate, string, bl, n, adb, timeProvider, logger, adbDeviceEventsListener, duration);
    }

    public int hashCode() {
        int result = this.getCoordinate().hashCode();
        result = result * 31 + this.getModel().hashCode();
        int n = this.getOnline() ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + Integer.hashCode(this.getApi());
        result = result * 31 + this.adb.hashCode();
        result = result * 31 + this.timeProvider.hashCode();
        result = result * 31 + this.getLogger().hashCode();
        result = result * 31 + this.eventsListener.hashCode();
        result = result * 31 + this.adbPullTimeout.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AdbDevice)) {
            return false;
        }
        AdbDevice adbDevice = (AdbDevice)other;
        if (!Intrinsics.areEqual((Object)this.getCoordinate(), (Object)adbDevice.getCoordinate())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getModel(), (Object)adbDevice.getModel())) {
            return false;
        }
        if (this.getOnline() != adbDevice.getOnline()) {
            return false;
        }
        if (this.getApi() != adbDevice.getApi()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.adb, (Object)adbDevice.adb)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.timeProvider, (Object)adbDevice.timeProvider)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getLogger(), (Object)adbDevice.getLogger())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.eventsListener, (Object)adbDevice.eventsListener)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.adbPullTimeout, (Object)adbDevice.adbPullTimeout);
    }

    private static final DeviceTestCaseRun runIsolatedTest$lambda-2(AdbDevice this$0, long $startTime, InstrumentationTestRunAction $action, InstrumentationTestCaseRun it) {
        DeviceTestCaseRun deviceTestCaseRun;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        InstrumentationTestCaseRun instrumentationTestCaseRun = it;
        if (instrumentationTestCaseRun instanceof InstrumentationTestCaseRun.CompletedTestCaseRun) {
            TestCaseRun.Result result = ((InstrumentationTestCaseRun.CompletedTestCaseRun)it).getResult();
            if (Intrinsics.areEqual((Object)result, (Object)TestCaseRun.Result.Passed.INSTANCE)) {
                this$0.eventsListener.onRunTestPassed(this$0, ((InstrumentationTestCaseRun.CompletedTestCaseRun)it).getName().toString(), this$0.timeProvider.nowInMillis() - $startTime);
            } else if (Intrinsics.areEqual((Object)result, (Object)TestCaseRun.Result.Ignored.INSTANCE)) {
                this$0.eventsListener.onRunTestIgnored(this$0, ((InstrumentationTestCaseRun.CompletedTestCaseRun)it).getName().toString(), this$0.timeProvider.nowInMillis() - $startTime);
            } else if (result instanceof TestCaseRun.Result.Failed.InRun) {
                this$0.eventsListener.onRunTestRunError(this$0, ((InstrumentationTestCaseRun.CompletedTestCaseRun)it).getName().toString(), ((TestCaseRun.Result.Failed.InRun)((InstrumentationTestCaseRun.CompletedTestCaseRun)it).getResult()).getErrorMessage(), this$0.timeProvider.nowInMillis() - $startTime);
            } else if (result instanceof TestCaseRun.Result.Failed.InfrastructureError) {
                AdbDeviceEventsListener adbDeviceEventsListener = this$0.eventsListener;
                Device device = this$0;
                String string = ((InstrumentationTestCaseRun.CompletedTestCaseRun)it).getName().toString();
                String string2 = ((TestCaseRun.Result.Failed.InfrastructureError)((InstrumentationTestCaseRun.CompletedTestCaseRun)it).getResult()).getError().getMessage();
                if (string2 == null) {
                    string2 = "Empty error message";
                }
                adbDeviceEventsListener.onRunTestInfrastructureError(device, string, string2, ((TestCaseRun.Result.Failed.InfrastructureError)((InstrumentationTestCaseRun.CompletedTestCaseRun)it).getResult()).getError(), this$0.timeProvider.nowInMillis() - $startTime);
            }
            deviceTestCaseRun = new DeviceTestCaseRun(new TestCaseRun(new TestCase(((InstrumentationTestCaseRun.CompletedTestCaseRun)it).getName(), $action.getTest().getDeviceName()), ((InstrumentationTestCaseRun.CompletedTestCaseRun)it).getResult(), ((InstrumentationTestCaseRun.CompletedTestCaseRun)it).getTimestampStartedMilliseconds(), ((InstrumentationTestCaseRun.CompletedTestCaseRun)it).getTimestampCompletedMilliseconds()), DeviceDataKt.getData(this$0));
        } else if (instrumentationTestCaseRun instanceof InstrumentationTestCaseRun.FailedOnStartTestCaseRun) {
            this$0.eventsListener.onRunTestFailedOnStart(this$0, ((InstrumentationTestCaseRun.FailedOnStartTestCaseRun)it).getMessage(), this$0.timeProvider.nowInMillis() - $startTime);
            deviceTestCaseRun = new DeviceTestCaseRun(new TestCaseRun($action.getTest(), (TestCaseRun.Result)new TestCaseRun.Result.Failed.InfrastructureError.FailedOnStart((Throwable)new RuntimeException("Failed on start test case: " + ((InstrumentationTestCaseRun.FailedOnStartTestCaseRun)it).getMessage())), this$0.timeProvider.nowInMillis(), this$0.timeProvider.nowInMillis()), DeviceDataKt.getData(this$0));
        } else if (instrumentationTestCaseRun instanceof InstrumentationTestCaseRun.FailedOnInstrumentationParsing) {
            this$0.eventsListener.onRunTestFailedOnInstrumentationParse(this$0, ((InstrumentationTestCaseRun.FailedOnInstrumentationParsing)it).getMessage(), ((InstrumentationTestCaseRun.FailedOnInstrumentationParsing)it).getThrowable(), this$0.timeProvider.nowInMillis());
            deviceTestCaseRun = new DeviceTestCaseRun(new TestCaseRun($action.getTest(), (TestCaseRun.Result)new TestCaseRun.Result.Failed.InfrastructureError.FailedOnParsing((Throwable)new RuntimeException("Failed on instrumentation parsing", ((InstrumentationTestCaseRun.FailedOnInstrumentationParsing)it).getThrowable())), this$0.timeProvider.nowInMillis(), this$0.timeProvider.nowInMillis()), DeviceDataKt.getData(this$0));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return deviceTestCaseRun;
    }

    public static final /* synthetic */ AdbDeviceEventsListener access$getEventsListener$p(AdbDevice $this) {
        return $this.eventsListener;
    }

    public static final /* synthetic */ Notification.Exit access$executeBlockingAdbRequest(AdbDevice $this, AdbRequest request, long timeoutSeconds) {
        return $this.executeBlockingAdbRequest(request, timeoutSeconds);
    }

    public static final /* synthetic */ Duration access$getAdbPullTimeout$p(AdbDevice $this) {
        return $this.adbPullTimeout;
    }
}

