/*
 * Decompiled with CFR 0.152.
 */
package com.avito.runner.service.worker.device.adb;

import com.avito.android.Result;
import com.avito.android.stats.StatsDSender;
import com.avito.logger.Logger;
import com.avito.logger.LoggerFactory;
import com.avito.runner.service.worker.device.DeviceCoordinate;
import com.avito.runner.service.worker.device.adb.Adb;
import com.avito.runner.service.worker.device.adb.AdbDevice;
import com.avito.runner.service.worker.device.adb.AdbDeviceParams;
import com.avito.runner.service.worker.device.adb.GetSdkVersion;
import com.avito.runner.service.worker.device.adb.RetryAction;
import com.avito.runner.service.worker.device.adb.listener.AdbDeviceEventsListener;
import com.avito.runner.service.worker.device.adb.listener.AdbDeviceEventsLogger;
import com.avito.runner.service.worker.device.adb.listener.AdbDeviceMetrics;
import com.avito.runner.service.worker.device.adb.listener.CompositeAdbDeviceEventListener;
import com.avito.runner.service.worker.device.adb.listener.RunnerMetricsConfig;
import com.avito.time.TimeProvider;
import com.avito.utils.ProcessRunner;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/avito/runner/service/worker/device/adb/AdbDeviceFactory;", "", "loggerFactory", "Lcom/avito/logger/LoggerFactory;", "adb", "Lcom/avito/runner/service/worker/device/adb/Adb;", "timeProvider", "Lcom/avito/time/TimeProvider;", "metricsConfig", "Lcom/avito/runner/service/worker/device/adb/listener/RunnerMetricsConfig;", "processRunner", "Lcom/avito/utils/ProcessRunner;", "adbPullTimeout", "Ljava/time/Duration;", "(Lcom/avito/logger/LoggerFactory;Lcom/avito/runner/service/worker/device/adb/Adb;Lcom/avito/time/TimeProvider;Lcom/avito/runner/service/worker/device/adb/listener/RunnerMetricsConfig;Lcom/avito/utils/ProcessRunner;Ljava/time/Duration;)V", "create", "Lcom/avito/android/Result;", "Lcom/avito/runner/service/worker/device/adb/AdbDevice;", "coordinate", "Lcom/avito/runner/service/worker/device/DeviceCoordinate;", "adbDeviceParams", "Lcom/avito/runner/service/worker/device/adb/AdbDeviceParams;", "createEventListener", "Lcom/avito/runner/service/worker/device/adb/listener/AdbDeviceEventsListener;", "logger", "Lcom/avito/logger/Logger;", "getSdkVersion", "Lcom/avito/runner/service/worker/device/adb/GetSdkVersion;", "listener", "service"})
public final class AdbDeviceFactory {
    @NotNull
    private final LoggerFactory loggerFactory;
    @NotNull
    private final Adb adb;
    @NotNull
    private final TimeProvider timeProvider;
    @Nullable
    private final RunnerMetricsConfig metricsConfig;
    @NotNull
    private final ProcessRunner processRunner;
    @NotNull
    private final Duration adbPullTimeout;

    public AdbDeviceFactory(@NotNull LoggerFactory loggerFactory, @NotNull Adb adb, @NotNull TimeProvider timeProvider, @Nullable RunnerMetricsConfig metricsConfig, @NotNull ProcessRunner processRunner, @NotNull Duration adbPullTimeout) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)adb, (String)"adb");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)processRunner, (String)"processRunner");
        Intrinsics.checkNotNullParameter((Object)adbPullTimeout, (String)"adbPullTimeout");
        this.loggerFactory = loggerFactory;
        this.adb = adb;
        this.timeProvider = timeProvider;
        this.metricsConfig = metricsConfig;
        this.processRunner = processRunner;
        this.adbPullTimeout = adbPullTimeout;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result<AdbDevice> create(@NotNull DeviceCoordinate coordinate, @NotNull AdbDeviceParams adbDeviceParams) {
        Result result;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        Intrinsics.checkNotNullParameter((Object)adbDeviceParams, (String)"adbDeviceParams");
        Logger logger = this.loggerFactory.create("" + '[' + coordinate.getSerial() + ']');
        AdbDeviceEventsListener listener = this.createEventListener(logger);
        Result<Integer> result2 = this.getSdkVersion(listener).get(coordinate.getSerial());
        boolean $i$f$map = false;
        void var7_7 = this_$iv;
        if (var7_7 instanceof Result.Success) {
            Result result3;
            try {
                int sdk = ((Number)((Result.Success)this_$iv).getValue()).intValue();
                boolean bl = false;
                AdbDevice adbDevice = new AdbDevice(coordinate, adbDeviceParams.getModel(), adbDeviceParams.getOnline(), sdk, this.adb, this.timeProvider, logger, listener, this.adbPullTimeout);
                result3 = (Result)new Result.Success((Object)adbDevice);
            }
            catch (Throwable throwable$iv) {
                result3 = (Result)new Result.Failure(throwable$iv);
            }
            result = result3;
        } else if (var7_7 instanceof Result.Failure) {
            result = (Result)new Result.Failure(((Result.Failure)this_$iv).getThrowable());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    private final GetSdkVersion getSdkVersion(AdbDeviceEventsListener listener) {
        return new GetSdkVersion(this.processRunner, new RetryAction(this.timeProvider), this.adb, listener);
    }

    private final AdbDeviceEventsListener createEventListener(Logger logger) {
        AdbDeviceEventsListener adbDeviceEventsListener;
        if (this.metricsConfig == null) {
            adbDeviceEventsListener = new AdbDeviceEventsLogger(logger);
        } else {
            Object[] objectArray = new AdbDeviceEventsListener[]{new AdbDeviceEventsLogger(logger), new AdbDeviceMetrics(StatsDSender.Companion.create(this.metricsConfig.getStatsDConfig(), this.loggerFactory), this.metricsConfig.getRunnerPrefix())};
            adbDeviceEventsListener = new CompositeAdbDeviceEventListener(CollectionsKt.listOf((Object[])objectArray));
        }
        return adbDeviceEventsListener;
    }
}

