/*
 * Decompiled with CFR 0.152.
 */
package com.avito.runner.service.worker.device.adb;

import com.avito.runner.service.worker.device.Serial;
import com.avito.runner.service.worker.device.adb.AdbDeviceParams;
import com.avito.runner.service.worker.device.adb.AdbDeviceParser;
import com.google.common.net.InetAddresses;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0018\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0013"}, d2={"Lcom/avito/runner/service/worker/device/adb/AdbDeviceParser;", "", "()V", "adbDevicesLines", "Lkotlin/sequences/Sequence;", "", "output", "createDeviceParams", "Lcom/avito/runner/service/worker/device/adb/AdbDeviceParams;", "line", "createSerial", "Lcom/avito/runner/service/worker/device/Serial;", "value", "findDeviceInOrNull", "serial", "isRemote", "", "parse", "", "service"})
public final class AdbDeviceParser {
    @Nullable
    public final AdbDeviceParams findDeviceInOrNull(@NotNull Serial serial, @NotNull String output) {
        AdbDeviceParams adbDeviceParams;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)serial, (String)"serial");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Sequence $this$firstOrNull$iv = SequencesKt.filter(this.adbDevicesLines(output), (Function1)findDeviceInOrNull.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String line = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)line, (CharSequence)serial.getValue(), (boolean)false, (int)2, null)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        String string = v0;
        if (string != null) {
            String line = string;
            boolean bl = false;
            adbDeviceParams = this.createDeviceParams(line);
        } else {
            adbDeviceParams = null;
        }
        return adbDeviceParams;
    }

    @NotNull
    public final Set<AdbDeviceParams> parse(@NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(this.adbDevicesLines(output), (Function1)parse.1.INSTANCE), (Function1)((Function1)new Function1<String, AdbDeviceParams>((Object)this){

            @NotNull
            public final AdbDeviceParams invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return AdbDeviceParser.access$createDeviceParams((AdbDeviceParser)this.receiver, p0);
            }
        })));
    }

    private final AdbDeviceParams createDeviceParams(String line) {
        boolean bl;
        Serial serial = this.createSerial(StringsKt.substringBefore$default((String)line, (String)" ", null, (int)2, null));
        String string = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)line, (String)"model:", null, (int)2, null), (String)" device", null, (int)2, null);
        if (StringsKt.contains((CharSequence)line, (CharSequence)"offline", (boolean)true)) {
            bl = false;
        } else if (StringsKt.contains((CharSequence)line, (CharSequence)"device", (boolean)true)) {
            bl = true;
        } else {
            throw new IllegalStateException("Unknown devicesManager output for device: " + line);
        }
        return new AdbDeviceParams(serial, string, bl);
    }

    private final Serial createSerial(String value) {
        return this.isRemote(value) ? (Serial)new Serial.Remote(value) : (Serial)new Serial.Local(value);
    }

    private final boolean isRemote(String serial) {
        return StringsKt.contains$default((CharSequence)serial, (char)':', (boolean)false, (int)2, null) && InetAddresses.isInetAddress((String)StringsKt.substringBefore$default((String)serial, (char)':', null, (int)2, null));
    }

    private final Sequence<String> adbDevicesLines(String output) {
        CharSequence charSequence = StringsKt.substringAfter$default((String)output, (String)"List of devices attached", null, (int)2, null);
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)System.lineSeparator(), (String)"lineSeparator()");
        Sequence sanitizedOutput2 = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null)), (Function1)adbDevicesLines.sanitizedOutput.1.INSTANCE), (Function1)adbDevicesLines.sanitizedOutput.2.INSTANCE);
        if (!(!SequencesKt.contains((Sequence)sanitizedOutput2, (Object)"error: cannot connect to daemon"))) {
            boolean bl = false;
            String string = "Cannot connect to adb daemon:\n" + output;
            throw new IllegalStateException(string.toString());
        }
        return sanitizedOutput2;
    }

    public static final /* synthetic */ AdbDeviceParams access$createDeviceParams(AdbDeviceParser $this, String line) {
        return $this.createDeviceParams(line);
    }
}

