/*
 * Decompiled with CFR 0.152.
 */
package com.avito.runner.service.worker.device.adb;

import com.avito.android.Result;
import com.avito.runner.service.worker.device.adb.RetryAction;
import com.avito.time.TimeProvider;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u008a\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2M\b\u0002\u0010\f\u001aG\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\r28\b\u0002\u0010\u0015\u001a2\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u00162M\b\u0002\u0010\u0017\u001aG\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u0011H\u0007\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/avito/runner/service/worker/device/adb/RetryAction;", "", "timeProvider", "Lcom/avito/time/TimeProvider;", "(Lcom/avito/time/TimeProvider;)V", "retry", "Lcom/avito/android/Result;", "T", "retriesCount", "", "delaySeconds", "", "onError", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "attempt", "", "throwable", "durationMs", "", "onFailure", "Lkotlin/Function2;", "onSuccess", "t", "action", "Lkotlin/Function0;", "service"})
public final class RetryAction {
    @NotNull
    private final TimeProvider timeProvider;

    public RetryAction(@NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.timeProvider = timeProvider;
    }

    @NotNull
    public final <T> Result<T> retry(int retriesCount, long delaySeconds, @NotNull Function3<? super Integer, ? super Throwable, ? super Long, Unit> onError, @NotNull Function2<? super Throwable, ? super Long, Unit> onFailure, @NotNull Function3<? super Integer, ? super T, ? super Long, Unit> onSuccess, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        int attempt = 0;
        if (attempt <= retriesCount) {
            while (true) {
                long attemptStartTime = this.timeProvider.nowInMillis();
                if (attempt > 0) {
                    TimeUnit.SECONDS.sleep(delaySeconds);
                }
                try {
                    Object result = action.invoke();
                    onSuccess.invoke((Object)attempt, result, (Object)(this.timeProvider.nowInMillis() - attemptStartTime));
                    return (Result)new Result.Success(result);
                }
                catch (Throwable e) {
                    if (attempt == retriesCount - 1) {
                        onFailure.invoke((Object)e, (Object)(this.timeProvider.nowInMillis() - attemptStartTime));
                        return (Result)new Result.Failure(e);
                    }
                    onError.invoke((Object)attempt, (Object)e, (Object)(this.timeProvider.nowInMillis() - attemptStartTime));
                    if (attempt == retriesCount) break;
                    ++attempt;
                    continue;
                }
                break;
            }
        }
        throw new IllegalStateException("retry must return value or throw exception");
    }

    public static /* synthetic */ Result retry$default(RetryAction retryAction, int n, long l, Function3 function3, Function2 function2, Function3 function32, Function0 function0, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l = 1L;
        }
        if ((n2 & 4) != 0) {
            function3 = retry.1.INSTANCE;
        }
        if ((n2 & 8) != 0) {
            function2 = retry.2.INSTANCE;
        }
        if ((n2 & 0x10) != 0) {
            function32 = retry.3.INSTANCE;
        }
        return retryAction.retry(n, l, (Function3<? super Integer, ? super Throwable, ? super Long, Unit>)function3, (Function2<? super Throwable, ? super Long, Unit>)function2, function32, function0);
    }
}

