/*
 * Decompiled with CFR 0.152.
 */
package com.avito.runner.service.worker.listener;

import com.avito.logger.Logger;
import com.avito.runner.service.model.DeviceTestCaseRun;
import com.avito.runner.service.model.intention.Intention;
import com.avito.runner.service.model.intention.State;
import com.avito.runner.service.worker.device.Device;
import com.avito.runner.service.worker.listener.DeviceListener;
import com.avito.runner.service.worker.model.DeviceInstallation;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ!\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ!\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ!\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J!\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Lcom/avito/runner/service/worker/listener/DeviceLogListener;", "Lcom/avito/runner/service/worker/listener/DeviceListener;", "deviceLogger", "Lcom/avito/logger/Logger;", "(Lcom/avito/logger/Logger;)V", "onApplicationInstalled", "", "device", "Lcom/avito/runner/service/worker/device/Device;", "installation", "Lcom/avito/runner/service/worker/model/DeviceInstallation;", "(Lcom/avito/runner/service/worker/device/Device;Lcom/avito/runner/service/worker/model/DeviceInstallation;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onDeviceCreated", "state", "Lcom/avito/runner/service/model/intention/State;", "(Lcom/avito/runner/service/worker/device/Device;Lcom/avito/runner/service/model/intention/State;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onDeviceDied", "message", "", "reason", "", "(Lcom/avito/runner/service/worker/device/Device;Ljava/lang/String;Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onFinished", "(Lcom/avito/runner/service/worker/device/Device;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onIntentionFail", "intention", "Lcom/avito/runner/service/model/intention/Intention;", "(Lcom/avito/runner/service/worker/device/Device;Lcom/avito/runner/service/model/intention/Intention;Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onIntentionReceived", "(Lcom/avito/runner/service/worker/device/Device;Lcom/avito/runner/service/model/intention/Intention;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onStatePrepared", "onTestCompleted", "result", "Lcom/avito/runner/service/model/DeviceTestCaseRun;", "(Lcom/avito/runner/service/worker/device/Device;Lcom/avito/runner/service/model/intention/Intention;Lcom/avito/runner/service/model/DeviceTestCaseRun;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onTestStarted", "service"})
public final class DeviceLogListener
implements DeviceListener {
    @NotNull
    private final Logger deviceLogger;

    public DeviceLogListener(@NotNull Logger deviceLogger) {
        Intrinsics.checkNotNullParameter((Object)deviceLogger, (String)"deviceLogger");
        this.deviceLogger = deviceLogger;
    }

    @Override
    @Nullable
    public Object onDeviceCreated(@NotNull Device device, @NotNull State state, @NotNull Continuation<? super Unit> $completion) {
        this.deviceLogger.info("Device is online (" + state + ')');
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object onIntentionReceived(@NotNull Device device, @NotNull Intention intention, @NotNull Continuation<? super Unit> $completion) {
        this.deviceLogger.info("Received intention: " + intention);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object onApplicationInstalled(@NotNull Device device, @NotNull DeviceInstallation installation, @NotNull Continuation<? super Unit> $completion) {
        this.deviceLogger.info("Application installed: " + installation.getInstallation());
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object onStatePrepared(@NotNull Device device, @NotNull State state, @NotNull Continuation<? super Unit> $completion) {
        this.deviceLogger.info("State prepared: (" + state + ')');
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object onTestStarted(@NotNull Device device, @NotNull Intention intention, @NotNull Continuation<? super Unit> $completion) {
        this.deviceLogger.info("Worker test run started for intention: " + intention);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object onTestCompleted(@NotNull Device device, @NotNull Intention intention, @NotNull DeviceTestCaseRun result, @NotNull Continuation<? super Unit> $completion) {
        this.deviceLogger.info("Worker test run completed for intention: " + intention);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object onIntentionFail(@NotNull Device device, @NotNull Intention intention, @NotNull Throwable reason, @NotNull Continuation<? super Unit> $completion) {
        this.deviceLogger.warn("Device can't process intention: " + intention, reason);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object onDeviceDied(@NotNull Device device, @NotNull String message, @NotNull Throwable reason, @NotNull Continuation<? super Unit> $completion) {
        this.deviceLogger.warn("Device died: " + message, reason);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object onFinished(@NotNull Device device, @NotNull Continuation<? super Unit> $completion) {
        this.deviceLogger.info("Worker ended with success result");
        return Unit.INSTANCE;
    }
}

