/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.console;

import com.axiastudio.zoefx.core.IOC;
import com.axiastudio.zoefx.core.script.JSEngineImpl;
import com.axiastudio.zoefx.core.script.ScriptEngine;
import com.axiastudio.zoefx.desktop.controller.Controller;
import java.net.URL;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToolBar;

public class ConsoleController
implements Initializable {
    private Controller controller;
    @FXML
    private ToolBar toolBar;
    @FXML
    private TextArea source;
    @FXML
    private TextArea output;
    private EventHandler<ActionEvent> handlerExecute = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent e) {
            ScriptEngine engine = (ScriptEngine)IOC.queryUtility(ScriptEngine.class);
            if (engine == null) {
                engine = new JSEngineImpl();
            }
            String sourceText = ConsoleController.this.source.getText();
            HashMap<String, Controller> bindings = new HashMap<String, Controller>();
            bindings.put("controller", ConsoleController.this.controller);
            Object eval = engine.eval(sourceText, bindings);
            ConsoleController.this.output.appendText(eval + "\n");
        }
    };

    public void initialize(URL url, ResourceBundle resourceBundle) {
        Button button = new Button();
        button.setId("executeConsoleButton");
        this.toolBar.getItems().add((Object)button);
        button.setOnAction(this.handlerExecute);
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }
}

