/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.controller;

import com.axiastudio.zoefx.core.IOC;
import com.axiastudio.zoefx.core.beans.BeanAccess;
import com.axiastudio.zoefx.core.beans.BeanClassAccess;
import com.axiastudio.zoefx.core.report.ReportEngine;
import com.axiastudio.zoefx.core.report.Reports;
import com.axiastudio.zoefx.desktop.console.ConsoleController;
import com.axiastudio.zoefx.desktop.controller.BaseController;
import com.axiastudio.zoefx.desktop.db.DataSet;
import com.axiastudio.zoefx.desktop.db.TimeMachine;
import com.axiastudio.zoefx.desktop.events.DataSetEvent;
import com.axiastudio.zoefx.desktop.events.DataSetEventListener;
import com.axiastudio.zoefx.desktop.model.Model;
import com.axiastudio.zoefx.desktop.model.beans.LookupStringConverter;
import com.axiastudio.zoefx.desktop.model.property.ItemObjectProperty;
import com.axiastudio.zoefx.desktop.model.property.ZoeFXProperty;
import com.axiastudio.zoefx.desktop.skins.Skins;
import com.axiastudio.zoefx.desktop.view.Behavior;
import com.axiastudio.zoefx.desktop.view.Comparators;
import com.axiastudio.zoefx.desktop.view.SceneBuilders;
import com.axiastudio.zoefx.desktop.view.ZSceneBuilder;
import com.axiastudio.zoefx.desktop.view.ZSceneMode;
import com.axiastudio.zoefx.desktop.view.msgbox.MsgBoxBuilder;
import com.axiastudio.zoefx.desktop.view.msgbox.MsgBoxResponse;
import com.axiastudio.zoefx.desktop.view.report.ReportController;
import com.axiastudio.zoefx.desktop.view.search.SearchController;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.util.BuilderFactory;
import javafx.util.Callback;

public class Controller
extends BaseController
implements DataSetEventListener {
    private DataSet dataset = null;
    private ZSceneMode mode;
    private Behavior behavior = null;
    private TimeMachine timeMachine = null;
    private Map<String, Property> fxProperties = new HashMap<String, Property>();
    private Map<String, TableView> tableViews;
    private ResourceBundle resourceBundle;
    public EventHandler<ActionEvent> handlerGoFirst = e -> {
        this.unsetModel();
        this.dataset.goFirst();
        this.setModel(this.dataset.newModel());
        this.timeMachine.resetAndCreateSnapshot(this.fxProperties.values());
    };
    public EventHandler<ActionEvent> handlerGoPrevious = e -> {
        this.unsetModel();
        this.dataset.goPrevious();
        this.setModel(this.dataset.newModel());
        this.timeMachine.resetAndCreateSnapshot(this.fxProperties.values());
    };
    public EventHandler<ActionEvent> handlerGoNext = e -> {
        this.unsetModel();
        this.dataset.goNext();
        this.setModel(this.dataset.newModel());
        this.timeMachine.resetAndCreateSnapshot(this.fxProperties.values());
    };
    public EventHandler<ActionEvent> handlerGoLast = e -> {
        this.unsetModel();
        this.dataset.goLast();
        this.setModel(this.dataset.newModel());
        this.timeMachine.resetAndCreateSnapshot(this.fxProperties.values());
    };
    public EventHandler<ActionEvent> handlerSave = e -> {
        this.dataset.save();
        this.timeMachine.resetAndCreateSnapshot(this.fxProperties.values());
    };
    public EventHandler<ActionEvent> handlerConfirm = e -> ((Stage)this.getScene().getWindow()).close();
    public EventHandler<ActionEvent> handlerCancel = e -> {
        this.timeMachine.rollback();
        this.dataset.revert();
        this.timeMachine.resetAndCreateSnapshot(this.fxProperties.values());
    };
    public EventHandler<ActionEvent> handlerAdd = e -> {
        this.dataset.create();
        this.unsetModel();
        this.setModel(this.dataset.newModel());
    };
    public EventHandler<ActionEvent> handlerSearch = e -> {
        Model model = this.dataset.getCurrentModel();
        Class<Object> classToSearch = model.getEntityClass();
        String searchcolumns = null;
        String searchcriteria = null;
        if (this.behavior != null) {
            searchcolumns = this.behavior.getProperties().getProperty("searchcolumns");
            searchcriteria = this.behavior.getProperties().getProperty("searchcriteria");
        }
        if (searchcolumns == null) {
            searchcolumns = String.join((CharSequence)",", model.getKeys());
        }
        Callback callback = items -> {
            ArrayList store = new ArrayList();
            for (Object item : items) {
                store.add(item);
            }
            this.dataset.setStore(store);
            return true;
        };
        Stage stage = this.searchStage(classToSearch, searchcolumns, callback, searchcriteria);
        stage.show();
    };
    public EventHandler<ActionEvent> handlerDelete = e -> {
        MsgBoxResponse response = MsgBoxBuilder.create().title("Confirm deletion").masthead("Delete the current entity?").message("Delete the current entity?").showConfirm();
        if (response.equals((Object)MsgBoxResponse.OK)) {
            this.dataset.delete();
            this.unsetModel();
            this.setModel(this.dataset.newModel());
        }
    };
    public EventHandler<ActionEvent> handlerPrint = e -> {
        ReportEngine reportEngine = (ReportEngine)IOC.queryUtility(ReportEngine.class);
        if (reportEngine != null) {
            Class<Object> classToReport = this.dataset.getCurrentModel().getEntityClass();
            if (Reports.getTemplates(classToReport).size() > 0) {
                Stage stage = this.reportStage(classToReport);
                stage.show();
            } else {
                MsgBoxBuilder.create().title("Information").masthead("No reports avaiable for this entity.").message("No reports avaiable for this entity.").showInfo();
            }
        } else {
            MsgBoxBuilder.create().title("Information").masthead("No report engine configured.").message("No report engine configured.").showInfo();
        }
    };
    public EventHandler<ActionEvent> handlerRefresh = e -> this.refresh();
    public EventHandler<ActionEvent> handlerConsole = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent e) {
            URL url = this.getClass().getResource("/fxml/console.fxml");
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(url);
            loader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
            Parent root = null;
            try {
                root = (Parent)loader.load(url.openStream());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ConsoleController console = (ConsoleController)loader.getController();
            console.setController(Controller.this.self());
            Stage stage = new Stage();
            stage.setTitle("Zoe FX Script Console");
            stage.setScene(new Scene(root, 450.0, 450.0));
            stage.show();
        }
    };
    public EventHandler<ActionEvent> handlerInfo = e -> {};
    public InvalidationListener invalidationListener = observable -> this.dataset.getDirty();

    public void initialize(URL url, ResourceBundle resource) {
        this.resourceBundle = resource;
    }

    public void bindDataSet(DataSet dataset) {
        this.dataset = dataset;
        if (dataset.size() == 0) {
            dataset.create();
        }
        Model model = dataset.newModel();
        this.scanFXProperties();
        this.initializeChoices();
        this.initializeColumns();
        this.setModel(model);
        this.timeMachine.createSnapshot(this.fxProperties.values());
    }

    private void initializeColumns() {
        Model model = this.dataset.getCurrentModel();
        Parent root = this.getScene().getRoot();
        Pane container = (Pane)root;
        List<Node> nodes = this.findNodes(container, new ArrayList<Node>());
        this.tableViews = new HashMap<String, TableView>();
        for (Node node : nodes) {
            if (!(node instanceof TableView)) continue;
            TableView tableView = (TableView)node;
            this.tableViews.put(node.getId(), tableView);
            ObservableList columns = tableView.getColumns();
            for (TableColumn column : columns) {
                BeanClassAccess beanClassAccess;
                Callback callback;
                String name = node.getId();
                String columnId = column.getId();
                if (columnId == null) {
                    columnId = column.getText().toLowerCase();
                }
                String lookup = null;
                if (this.behavior != null) {
                    lookup = this.behavior.getProperties().getProperty(columnId + ".lookup");
                }
                if (lookup != null) {
                    callback = model.getCallback(name, columnId, lookup);
                    column.setCellValueFactory(callback);
                } else {
                    callback = model.getCallback(name, columnId);
                    column.setCellValueFactory(callback);
                }
                if ((beanClassAccess = new BeanClassAccess(model.getEntityClass(), columnId)).getReturnType() == null || !Date.class.isAssignableFrom(beanClassAccess.getReturnType())) continue;
                column.setComparator(Comparator.nullsFirst(Comparators.DateComparator));
            }
        }
    }

    private void initializeChoices() {
        Model model = this.dataset.getCurrentModel();
        Parent root = this.getScene().getRoot();
        Pane container = (Pane)root;
        List<Node> nodes = this.findNodes(container, new ArrayList<Node>());
        for (Node node : nodes) {
            String lookup;
            if (!(node instanceof ChoiceBox)) continue;
            String name = node.getId();
            ZoeFXProperty property = model.getProperty(name, Object.class);
            List superset = ((ItemObjectProperty)property).getSuperset(this.getDataset().getManager());
            ObservableList choices = FXCollections.observableArrayList(superset);
            ChoiceBox choiceBox = (ChoiceBox)node;
            choiceBox.setItems(choices);
            if (this.behavior == null || (lookup = this.behavior.getProperties().getProperty(name + ".lookup")) == null) continue;
            choiceBox.setConverter(new LookupStringConverter(lookup));
        }
    }

    private void unsetModel() {
        Model model = this.dataset.getCurrentModel();
        for (String name : this.fxProperties.keySet()) {
            Property fxProperty = this.fxProperties.get(name);
            ZoeFXProperty zoeFXProperty = model.getProperty(name);
            if (fxProperty == null || zoeFXProperty == null) continue;
            Bindings.unbindBidirectional((Property)fxProperty, (Property)zoeFXProperty);
            fxProperty.removeListener(this.invalidationListener);
        }
    }

    private void setModel() {
        this.setModel(this.dataset.newModel());
    }

    private void setModel(Model model) {
        for (String name : this.fxProperties.keySet()) {
            Property fxProperty = this.fxProperties.get(name);
            ZoeFXProperty zoeFXProperty = model.getProperty(name);
            if (zoeFXProperty == null) {
                Node node = this.getScene().lookup("#" + name);
                if (node instanceof TextField) {
                    zoeFXProperty = model.getProperty(name, String.class);
                } else if (node instanceof TextArea) {
                    zoeFXProperty = model.getProperty(name, String.class);
                } else if (node instanceof Label) {
                    zoeFXProperty = model.getProperty(name, String.class);
                } else if (node instanceof CheckBox) {
                    zoeFXProperty = model.getProperty(name, Boolean.class);
                } else if (node instanceof ChoiceBox) {
                    zoeFXProperty = model.getProperty(name, Object.class);
                } else if (node instanceof DatePicker) {
                    zoeFXProperty = model.getProperty(name, Date.class);
                } else if (node instanceof TableView) {
                    zoeFXProperty = model.getProperty(name, Collection.class);
                }
            }
            if (fxProperty == null || zoeFXProperty == null) continue;
            Bindings.bindBidirectional((Property)fxProperty, (Property)zoeFXProperty);
            fxProperty.addListener(this.invalidationListener);
        }
    }

    private void scanFXProperties() {
        Parent root = this.getScene().getRoot();
        Pane container = (Pane)root;
        List<Node> nodes = this.findNodes(container, new ArrayList<Node>());
        for (Node node : nodes) {
            String name = node.getId();
            StringProperty property = null;
            if (node instanceof TextField) {
                property = ((TextField)node).textProperty();
            } else if (node instanceof TextArea) {
                property = ((TextArea)node).textProperty();
            } else if (node instanceof Label) {
                property = ((Label)node).textProperty();
            } else if (node instanceof CheckBox) {
                property = ((CheckBox)node).selectedProperty();
            } else if (node instanceof ChoiceBox) {
                property = ((ChoiceBox)node).valueProperty();
            } else if (node instanceof DatePicker) {
                property = ((DatePicker)node).valueProperty();
            } else if (node instanceof TableView) {
                TableView tableView = (TableView)node;
                tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                tableView.setContextMenu(this.createContextMenu(tableView));
                property = tableView.itemsProperty();
            }
            if (property == null) continue;
            this.fxProperties.put(name, (Property)property);
        }
    }

    private ContextMenu createContextMenu(TableView tableView) {
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.setId("tableViewContextMenu");
        MenuItem infoItem = new MenuItem("Information");
        infoItem.setId("infoContextMenu");
        infoItem.setOnAction(e -> {
            ObservableList selectedItems = tableView.getSelectionModel().getSelectedItems();
            if (selectedItems.size() == 0) {
                return;
            }
            ArrayList<Object> newStore = new ArrayList<Object>();
            for (int i = 0; i < selectedItems.size(); ++i) {
                newStore.add(selectedItems.get(i));
            }
            ZSceneBuilder sceneBuilder = SceneBuilders.querySceneBuilder(newStore.get(0).getClass());
            Scene newScene = sceneBuilder.manager(this.getDataset().getManager()).store(newStore).mode(ZSceneMode.DIALOG).build();
            if (newScene != null) {
                Stage newStage = new Stage();
                newStage.setScene(newScene);
                newStage.show();
                newStage.requestFocus();
            }
            this.dataset.getDirty();
        });
        MenuItem openItem = new MenuItem("Open");
        openItem.setId("openContextMenu");
        openItem.setOnAction(e -> {
            ObservableList selectedItems = tableView.getSelectionModel().getSelectedItems();
            if (selectedItems.size() == 0) {
                return;
            }
            ArrayList<Object> newStore = new ArrayList<Object>();
            String referenceProperty = tableView.getId() + ".reference";
            String reference = this.behavior.getProperties().getProperty(referenceProperty, null);
            for (int i = 0; i < selectedItems.size(); ++i) {
                Object item = selectedItems.get(i);
                if (reference != null) {
                    BeanAccess ba = new BeanAccess(item, reference);
                    newStore.add(ba.getValue());
                    continue;
                }
                newStore.add(item);
            }
            ZSceneBuilder sceneBuilder = SceneBuilders.querySceneBuilder(newStore.get(0).getClass());
            Scene newScene = sceneBuilder.manager(this.getDataset().getManager()).store(newStore).mode(ZSceneMode.WINDOW).build();
            if (newScene != null) {
                Stage newStage = new Stage();
                newStage.setScene(newScene);
                newStage.show();
                newStage.requestFocus();
            }
            this.dataset.getDirty();
        });
        MenuItem addItem = new MenuItem("Add");
        addItem.setId("addContextMenu");
        addItem.setOnAction(e -> {
            String collectionName = tableView.getId();
            String referenceProperty = collectionName + ".reference";
            String searchcolumnsProperty = collectionName + ".searchcolumns";
            String referenceName = this.behavior.getProperties().getProperty(referenceProperty, null);
            String searchcolumns = this.behavior.getProperties().getProperty(searchcolumnsProperty, "caption");
            if (referenceName != null) {
                Class<?> classToSearch = null;
                try {
                    Class<Object> parentEntityClass = this.dataset.getCurrentModel().getEntityClass();
                    Class collectionGenericReturnType = new BeanClassAccess(parentEntityClass, collectionName).getGenericReturnType();
                    Class referenceReturnType = new BeanClassAccess(collectionGenericReturnType, referenceName).getReturnType();
                    String className = referenceReturnType.getName();
                    classToSearch = Class.forName(className);
                    Callback callback = items -> {
                        for (Object item : items) {
                            Object entity = this.dataset.createRow(collectionName);
                            BeanAccess ba = new BeanAccess(entity, referenceName);
                            ba.setValue(item);
                            this.refresh();
                        }
                        return true;
                    };
                    Stage stage = this.searchStage(classToSearch, searchcolumns, callback);
                    stage.show();
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                }
            } else {
                Object entity = this.dataset.createRow(collectionName);
                ArrayList<Object> newStore = new ArrayList<Object>();
                newStore.add(entity);
                ZSceneBuilder sceneBuilder = SceneBuilders.querySceneBuilder(newStore.get(0).getClass());
                Scene newScene = sceneBuilder.manager(this.getDataset().getManager()).store(newStore).mode(ZSceneMode.DIALOG).build();
                if (newScene != null) {
                    Stage newStage = new Stage();
                    newStage.setScene(newScene);
                    newStage.show();
                    newStage.requestFocus();
                }
            }
            this.dataset.getDirty();
        });
        MenuItem delItem = new MenuItem("Delete");
        delItem.setId("delContextMenu");
        delItem.setOnAction(e -> {
            String collectionName = tableView.getId();
            ArrayList selectedItems = new ArrayList(tableView.getSelectionModel().getSelectedItems());
            for (Object item : selectedItems) {
                this.dataset.deleteRow(collectionName, item);
            }
            this.dataset.getDirty();
        });
        addItem.disableProperty().bind((ObservableValue)this.dataset.canUpdateProperty().not());
        delItem.disableProperty().bind((ObservableValue)this.dataset.canUpdateProperty().not());
        infoItem.disableProperty().bind((ObservableValue)this.dataset.canUpdateProperty().not());
        openItem.disableProperty().bind((ObservableValue)this.dataset.canUpdateProperty().not());
        contextMenu.getItems().addAll((Object[])new MenuItem[]{infoItem, openItem, addItem, delItem});
        return contextMenu;
    }

    private List<Node> findNodes(Pane container, List<Node> nodes) {
        for (Node node : container.getChildren()) {
            if (node instanceof Pane) {
                nodes = this.findNodes((Pane)node, nodes);
                continue;
            }
            if (node instanceof TabPane) {
                for (Tab tab : ((TabPane)node).getTabs()) {
                    if (tab.getContent() instanceof Pane) {
                        nodes = this.findNodes((Pane)tab.getContent(), nodes);
                        continue;
                    }
                    nodes.add(tab.getContent());
                }
                continue;
            }
            if (node.getId() == null || node.getId() == "") continue;
            nodes.add(node);
        }
        return nodes;
    }

    public DataSet getDataset() {
        return this.dataset;
    }

    public Model getCurrentModel() {
        return this.dataset.getCurrentModel();
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    private Controller self() {
        return this;
    }

    public ZSceneMode getMode() {
        return this.mode;
    }

    public void setMode(ZSceneMode mode) {
        this.mode = mode;
    }

    public void setBehavior(Behavior behavior) {
        this.behavior = behavior;
    }

    public void setTimeMachine(TimeMachine timeMachine) {
        this.timeMachine = timeMachine;
    }

    public void refresh() {
        this.unsetModel();
        Model model = this.dataset.newModel();
        this.setModel(model);
        this.timeMachine.resetAndCreateSnapshot(this.fxProperties.values());
        for (TableView tableView : this.tableViews.values()) {
            ObservableList items = tableView.getItems();
            tableView.itemsProperty().removeListener(this.invalidationListener);
            tableView.setItems(null);
            tableView.layout();
            tableView.setItems(items);
            tableView.itemsProperty().addListener(this.invalidationListener);
        }
    }

    private Stage reportStage(Class classToReport) {
        URL url = this.getClass().getResource("/fxml/report.fxml");
        FXMLLoader loader = new FXMLLoader(url, this.resourceBundle);
        loader.setLocation(url);
        loader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
        Parent root = null;
        try {
            root = (Parent)loader.load(url.openStream());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ReportController controller = (ReportController)loader.getController();
        controller.setEntityClass(classToReport);
        controller.setStore(this.getDataset().getStore());
        Stage stage = new Stage();
        stage.setTitle(this.resourceBundle.getString("report.title"));
        Scene scene = new Scene(root, 350.0, 100.0);
        controller.setScene(scene);
        stage.setScene(scene);
        return stage;
    }

    public Stage searchStage(Class classToSearch, String searchcolumns, Callback callback) {
        return this.searchStage(classToSearch, searchcolumns, callback, null);
    }

    private Stage searchStage(Class classToSearch, String searchcolumns, Callback callback, String searchcriteria) {
        URL url = this.getClass().getResource("/fxml/search.fxml");
        FXMLLoader loader = new FXMLLoader();
        loader.setResources(this.resourceBundle);
        loader.setLocation(url);
        loader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
        Parent root = null;
        try {
            root = (Parent)loader.load(url.openStream());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        SearchController controller = (SearchController)loader.getController();
        controller.setEntityClass(classToSearch);
        controller.setBehavior(this.behavior);
        ArrayList<String> columns = new ArrayList<String>();
        if (searchcolumns != null) {
            String[] split = searchcolumns.split(",");
            for (int i = 0; i < split.length; ++i) {
                columns.add(split[i]);
            }
        }
        controller.setColumns(columns);
        ArrayList<String> criteria = new ArrayList<String>();
        if (searchcriteria != null) {
            String[] split = searchcriteria.split(",");
            for (int i = 0; i < split.length; ++i) {
                criteria.add(split[i]);
            }
        }
        controller.setCriteria(criteria);
        controller.setCallback(callback);
        Stage stage = new Stage();
        stage.setTitle("Search");
        Scene scene = new Scene(root, 800.0, 600.0);
        Skins.getActiveSkin().getStyle().ifPresent(s -> scene.getStylesheets().add(s));
        stage.setScene(scene);
        return stage;
    }

    @Override
    public void dataSetEventHandler(DataSetEvent event) {
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "{0} event handled", event.getEventType().getName());
        if (event.getEventType().equals(DataSetEvent.STORE_CHANGED)) {
            this.storeChanged();
            this.unsetModel();
            this.setModel();
        } else if (event.getEventType().equals(DataSetEvent.BEFORE_DELETE)) {
            this.beforeDelete();
        } else if (event.getEventType().equals(DataSetEvent.DELETED)) {
            this.deleted();
        } else if (event.getEventType().equals(DataSetEvent.ROWS_CREATED)) {
            this.rowsCreated();
            this.refresh();
        } else if (event.getEventType().equals(DataSetEvent.ROWS_DELETED)) {
            this.rowsDeleted();
            this.refresh();
        } else if (event.getEventType().equals(DataSetEvent.GET_DIRTY)) {
            this.getDirty();
        } else if (event.getEventType().equals(DataSetEvent.BEFORE_COMMIT)) {
            this.beforeCommit();
        } else if (event.getEventType().equals(DataSetEvent.COMMITED)) {
            this.committed();
        } else if (event.getEventType().equals(DataSetEvent.INDEX_CHANGED)) {
            this.indexChanged();
        }
    }

    protected void storeChanged() {
    }

    protected void rowsCreated() {
    }

    protected void rowsDeleted() {
    }

    protected void getDirty() {
    }

    protected void beforeCommit() {
    }

    protected void committed() {
    }

    protected void indexChanged() {
    }

    protected void beforeDelete() {
    }

    protected void deleted() {
    }
}

