/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.db;

import com.axiastudio.zoefx.core.IOC;
import com.axiastudio.zoefx.core.beans.BeanAccess;
import com.axiastudio.zoefx.core.db.Database;
import com.axiastudio.zoefx.core.db.EntityListener;
import com.axiastudio.zoefx.core.db.Manager;
import com.axiastudio.zoefx.desktop.events.DataSetEvent;
import com.axiastudio.zoefx.desktop.events.DataSetEventGenerator;
import com.axiastudio.zoefx.desktop.events.DataSetEventListener;
import com.axiastudio.zoefx.desktop.model.Model;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleBooleanProperty;

public class DataSet<E>
implements DataSetEventGenerator {
    private List<E> store;
    private Class<E> entityClass;
    private Manager<E> manager = null;
    private EntityListener<E> listener = null;
    private Integer currentIndex;
    private Model<E> currentModel = null;
    private Boolean dirty = Boolean.FALSE;
    private List<DataSetEventListener> dataSetEventListeners = new ArrayList<DataSetEventListener>();
    private SimpleBooleanProperty canSelect = new SimpleBooleanProperty(Boolean.TRUE.booleanValue());
    private SimpleBooleanProperty canInsert = new SimpleBooleanProperty(Boolean.TRUE.booleanValue());
    private SimpleBooleanProperty canUpdate = new SimpleBooleanProperty(Boolean.TRUE.booleanValue());
    private SimpleBooleanProperty canDelete = new SimpleBooleanProperty(Boolean.TRUE.booleanValue());

    public boolean getCanSelect() {
        return this.canSelect.get();
    }

    public SimpleBooleanProperty canSelectProperty() {
        return this.canSelect;
    }

    public void setCanSelect(boolean canSelect) {
        this.canSelect.set(canSelect);
    }

    public boolean getCanInsert() {
        return this.canInsert.get();
    }

    public SimpleBooleanProperty canInsertProperty() {
        return this.canInsert;
    }

    public void setCanInsert(boolean canInsert) {
        this.canInsert.set(canInsert);
    }

    public boolean getCanUpdate() {
        return this.canUpdate.get();
    }

    public SimpleBooleanProperty canUpdateProperty() {
        return this.canUpdate;
    }

    public void setCanUpdate(boolean canUpdate) {
        this.canUpdate.set(canUpdate);
    }

    public boolean getCanDelete() {
        return this.canDelete.get();
    }

    public SimpleBooleanProperty canDeleteProperty() {
        return this.canDelete;
    }

    public void setCanDelete(boolean canDelete) {
        this.canDelete.set(canDelete);
    }

    public void setStore(List<E> store) {
        this.store = store;
        this.goFirst();
        this.fireDataSetEvent(new DataSetEvent(DataSetEvent.STORE_CHANGED));
        this.dirty = Boolean.FALSE;
    }

    public List<E> getStore() {
        if (this.store == null) {
            this.store = this.manager.getAll();
        }
        return this.store;
    }

    public Integer getCurrentIndex() {
        return this.currentIndex;
    }

    public Model<E> newModel() {
        E entity = this.getStore().get(this.currentIndex);
        this.currentModel = new Model<E>(entity);
        this.fireDataSetEvent(new DataSetEvent(DataSetEvent.INDEX_CHANGED));
        return this.currentModel;
    }

    public Model<E> getCurrentModel() {
        return this.currentModel;
    }

    public void goFirst() {
        this.currentIndex = 0;
    }

    public void goLast() {
        this.currentIndex = this.getStore().size() - 1;
    }

    public void goNext() {
        if (this.currentIndex < this.getStore().size() - 1) {
            Integer n = this.currentIndex;
            Integer n2 = this.currentIndex = Integer.valueOf(this.currentIndex + 1);
        }
    }

    public void goPrevious() {
        if (this.currentIndex > 0) {
            Integer n = this.currentIndex;
            Integer n2 = this.currentIndex = Integer.valueOf(this.currentIndex - 1);
        }
    }

    public Integer size() {
        return this.getStore().size();
    }

    public Boolean isDirty() {
        return this.dirty;
    }

    public void getDirty() {
        if (!this.dirty.booleanValue()) {
            this.dirty = Boolean.TRUE;
            this.fireDataSetEvent(new DataSetEvent(DataSetEvent.GET_DIRTY));
        }
    }

    public void revert() {
        this.dirty = Boolean.FALSE;
        this.fireDataSetEvent(new DataSetEvent(DataSetEvent.REVERTED));
    }

    public void save() {
        this.fireDataSetEvent(new DataSetEvent(DataSetEvent.BEFORE_COMMIT));
        Manager<E> manager = this.getManager();
        if (manager != null) {
            E entity = this.getStore().get(this.currentIndex);
            Object merged = manager.save(entity);
            this.getStore().set(this.currentIndex, merged);
        }
        this.dirty = Boolean.FALSE;
        this.fireDataSetEvent(new DataSetEvent(DataSetEvent.COMMITED));
    }

    public Manager<E> getManager() {
        Database db;
        if (this.manager == null && (db = (Database)IOC.queryUtility(Database.class)) != null) {
            this.manager = db.createManager(this.getEntityClass());
        }
        return this.manager;
    }

    public void setManager(Manager<E> manager) {
        this.manager = manager;
    }

    public void setListener(EntityListener<E> listener) {
        this.listener = listener;
    }

    public Class<E> getEntityClass() {
        if (this.entityClass == null) {
            if (this.getStore().size() == 0) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "The entity class is not defined and the size of the store is 0!");
            } else {
                return this.getStore().get(0).getClass();
            }
        }
        return this.entityClass;
    }

    public void setEntityClass(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    public E create() {
        Manager<E> manager = this.getManager();
        if (manager != null) {
            Object entity = manager.create();
            this.getStore().add(entity);
            this.currentIndex = this.getStore().size() - 1;
            this.fireDataSetEvent(new DataSetEvent(DataSetEvent.CREATED));
            return (E)entity;
        }
        try {
            E entity = this.getEntityClass().newInstance();
            this.getStore().add(entity);
            this.currentIndex = this.getStore().size() - 1;
            this.fireDataSetEvent(new DataSetEvent(DataSetEvent.CREATED));
            return entity;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object createRow(String collectionName) {
        Database db = (Database)IOC.queryUtility(Database.class);
        E parentEntity = this.getStore().get(this.currentIndex);
        BeanAccess beanAccess = new BeanAccess(parentEntity, collectionName);
        Collection collection = (Collection)beanAccess.getValue();
        Class genericReturnType = beanAccess.getGenericReturnType();
        if (db != null) {
            Object row = this.getManager().createRow(collectionName);
            collection.add(row);
            this.fireDataSetEvent(new DataSetEvent(DataSetEvent.ROWS_CREATED));
            this.fireDataSetEvent(new DataSetEvent(DataSetEvent.GET_DIRTY));
            return row;
        }
        try {
            Object entity = genericReturnType.newInstance();
            collection.add(entity);
            this.fireDataSetEvent(new DataSetEvent(DataSetEvent.ROWS_CREATED));
            this.fireDataSetEvent(new DataSetEvent(DataSetEvent.GET_DIRTY));
            return entity;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void delete() {
        this.fireDataSetEvent(new DataSetEvent(DataSetEvent.BEFORE_DELETE));
        Manager<E> manager = this.getManager();
        if (manager != null) {
            E entity = this.getStore().get(this.currentIndex);
            manager.delete(entity);
            this.getStore().remove(this.currentIndex);
            this.currentIndex = this.getStore().size() - 1;
        } else {
            this.getStore().remove(this.currentIndex);
            this.currentIndex = this.getStore().size() - 1;
        }
        this.fireDataSetEvent(new DataSetEvent(DataSetEvent.DELETED));
    }

    public void deleteRow(String collectionName, E row) {
        Database db = (Database)IOC.queryUtility(Database.class);
        E parentEntity = this.getStore().get(this.currentIndex);
        BeanAccess beanAccess = new BeanAccess(parentEntity, collectionName);
        Collection collection = (Collection)beanAccess.getValue();
        collection.remove(row);
        if (db != null) {
            this.getManager().deleteRow(row);
        }
        this.fireDataSetEvent(new DataSetEvent(DataSetEvent.ROWS_DELETED));
        this.fireDataSetEvent(new DataSetEvent(DataSetEvent.GET_DIRTY));
    }

    @Override
    public void addDataSetEventListener(DataSetEventListener listener) {
        this.dataSetEventListeners.add(listener);
    }

    private void fireDataSetEvent(DataSetEvent event) {
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "{0} event fired", event.getEventType().getName());
        for (DataSetEventListener dataSetEventListener : this.dataSetEventListeners) {
            dataSetEventListener.dataSetEventHandler(event);
        }
        if (this.listener != null) {
            E entity = this.getStore().get(this.currentIndex);
            if (event.getEventType().equals(DataSetEvent.BEFORE_COMMIT)) {
                this.listener.beforeCommit(entity);
            }
        }
    }
}

