/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.db;

import com.axiastudio.zoefx.core.beans.BeanClassAccess;
import com.axiastudio.zoefx.core.db.AbstractManager;
import com.axiastudio.zoefx.core.db.Manager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NoPersistenceDatabaseManagerImpl<E>
extends AbstractManager<E>
implements Manager<E> {
    private List<E> store;
    private Class<E> entityClass;

    public NoPersistenceDatabaseManagerImpl(Class entityClass) {
        this.entityClass = entityClass;
        this.store = new ArrayList();
    }

    public Object getId(E entity) {
        throw new UnsupportedOperationException("Method getId not supported in NoPersistenceDatabaseManagerImpl.");
    }

    public NoPersistenceDatabaseManagerImpl(List<E> store) {
        this.store = store;
        this.entityClass = store.get(0).getClass();
    }

    public E save(E entity) {
        if (!this.store.contains(entity)) {
            this.store.add(entity);
        }
        return entity;
    }

    public void save(List<E> entities) {
        for (E entity : entities) {
            this.store.add(entity);
        }
    }

    public void delete(E entity) {
        this.store.remove(entity);
    }

    public void deleteRow(Object row) {
    }

    public void truncate() {
        this.store.clear();
    }

    public E get(Long id) {
        return this.store.get(id.intValue());
    }

    public List<E> query() {
        return this.store;
    }

    public List<E> query(Map<String, Object> map, List<String> orderby, List<Boolean> reverse, Integer size, Integer startindex) {
        return this.query();
    }

    public E create() {
        try {
            return this.entityClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object createRow(String collectionName) {
        BeanClassAccess beanClassAccess = new BeanClassAccess(this.entityClass, collectionName);
        Class genericReturnType = beanClassAccess.getGenericReturnType();
        try {
            return genericReturnType.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

