/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.Property;

public class TimeMachine {
    private List<Map<Property, Object>> snapshots = new ArrayList<Map<Property, Object>>();

    public void resetAndCreateSnapshot(Collection<Property> properties) {
        this.reset();
        this.createSnapshot(properties);
    }

    public void createSnapshot(Collection<Property> properties) {
        HashMap<Property, Object> snapshot = new HashMap<Property, Object>();
        for (Property property : properties) {
            snapshot.put(property, property.getValue());
        }
        this.snapshots.add(snapshot);
    }

    public void undo() {
        int last = this.snapshots.size() - 1;
        Map<Property, Object> snapshot = this.snapshots.get(last);
        this.snapshots.remove(last);
        for (Property property : snapshot.keySet()) {
            property.setValue(snapshot.get(property));
        }
    }

    public void rollback() {
        Map<Property, Object> snapshot = this.snapshots.get(0);
        for (Property property : snapshot.keySet()) {
            property.setValue(snapshot.get(property));
        }
        this.snapshots.clear();
    }

    public void reset() {
        this.snapshots.clear();
    }
}

