/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.model;

import com.axiastudio.zoefx.desktop.model.property.CallbackBuilder;
import com.axiastudio.zoefx.desktop.model.property.ItemPropertyBuilder;
import com.axiastudio.zoefx.desktop.model.property.ZoeFXProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.util.Callback;

public class Model<E> {
    private E entity;
    private Map<String, ZoeFXProperty> propertiesCache = new HashMap<String, ZoeFXProperty>();
    private Map<String, Callback> callbacksCache = new HashMap<String, Callback>();

    public Model(E entity) {
        this.entity = entity;
    }

    public ZoeFXProperty getProperty(String name) {
        if (this.propertiesCache.containsKey(name)) {
            return this.propertiesCache.get(name);
        }
        return null;
    }

    public List<ZoeFXProperty> getProperties() {
        return this.propertiesCache.keySet().stream().map(k -> this.propertiesCache.get(k)).collect(Collectors.toList());
    }

    public List<String> getKeys() {
        return this.propertiesCache.keySet().stream().collect(Collectors.toList());
    }

    public ZoeFXProperty getProperty(String name, Class<?> klass) {
        if (this.propertiesCache.containsKey(name)) {
            return this.propertiesCache.get(name);
        }
        ZoeFXProperty property = ItemPropertyBuilder.create(klass).bean(this.entity).field(name).build();
        this.propertiesCache.put(name, property);
        return property;
    }

    public Callback getCallback(String name, String columnId) {
        return this.getCallback(name, columnId, null);
    }

    public Callback getCallback(String name, String columnId, String lookup) {
        String key = name + "." + columnId;
        if (this.callbacksCache.containsKey(key)) {
            return this.callbacksCache.get(key);
        }
        CallbackBuilder cb = CallbackBuilder.create().beanClass(this.entity.getClass()).field(key);
        if (lookup != null) {
            cb = cb.lookup(lookup);
        }
        Callback callback = cb.build();
        return callback;
    }

    public Class<? extends Object> getEntityClass() {
        return this.entity.getClass();
    }

    public E getEntity() {
        return this.entity;
    }

    protected void finalize() throws Throwable {
        for (Property property : this.propertiesCache.values()) {
            property.unbind();
        }
    }
}

