/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.model.converters;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.regex.Pattern;
import javafx.util.Callback;

public class String2BigDecimal
implements Callback<String, BigDecimal> {
    public BigDecimal call(String param) {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance();
        String symbol = numberFormat.getCurrency().getSymbol();
        String regex = "-?(" + symbol + " )?[0-9]{1,3}(\\.?[0-9]{3})*(,[0-9]{2})?";
        if (!Pattern.matches(regex, param)) {
            return null;
        }
        try {
            Number number = numberFormat.parse(param);
            if (number instanceof Double) {
                return new BigDecimal((Double)number);
            }
            if (number instanceof Long) {
                return new BigDecimal((Long)number);
            }
        }
        catch (ParseException e) {
            return new BigDecimal(Double.parseDouble(param.replace(",", ".")));
        }
        catch (ClassCastException e) {
            return null;
        }
        return null;
    }
}

