/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.model.property;

import com.axiastudio.zoefx.core.beans.BeanClassAccess;
import com.axiastudio.zoefx.desktop.model.property.ItemPropertyBuilder;
import com.axiastudio.zoefx.desktop.model.property.ZoeFXProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class CallbackBuilder {
    private Class beanClass;
    private String collectionName = null;
    private String fieldName = null;
    private String lookup = null;

    public static CallbackBuilder create() {
        return new CallbackBuilder();
    }

    public CallbackBuilder beanClass(Class klass) {
        this.beanClass = klass;
        return this;
    }

    public CallbackBuilder field(String name) {
        String[] split = name.split("\\.");
        if (split.length == 1) {
            this.fieldName = split[0];
            this.collectionName = null;
        } else if (split.length == 2) {
            this.collectionName = split[0];
            this.fieldName = split[1];
        }
        return this;
    }

    public CallbackBuilder lookup(String lookup) {
        this.lookup = lookup;
        return this;
    }

    public Callback build() {
        Class pClass;
        if (this.collectionName != null) {
            BeanClassAccess beanClassAccess = new BeanClassAccess(this.beanClass, this.collectionName);
            pClass = beanClassAccess.getGenericReturnType();
        } else {
            pClass = this.beanClass;
        }
        BeanClassAccess beanPropertyClassAccess = new BeanClassAccess(pClass, this.fieldName);
        Class tClass = beanPropertyClassAccess.getReturnType();
        return this.createCallback(pClass, tClass, this.fieldName, this.lookup);
    }

    private <P, T> Callback<TableColumn.CellDataFeatures<P, T>, ObservableValue<T>> createCallback(Class<P> pClass, Class<T> tClass, String idColumn) {
        return this.createCallback(pClass, tClass, idColumn, null);
    }

    private <P, T> Callback<TableColumn.CellDataFeatures<P, T>, ObservableValue<T>> createCallback(Class<P> pClass, Class<T> tClass, final String idColumn, final String lookup) {
        Callback callback = new Callback<TableColumn.CellDataFeatures<P, T>, ObservableValue<T>>(){

            public ObservableValue<T> call(TableColumn.CellDataFeatures<P, T> ptCellDataFeatures) {
                Object bean = ptCellDataFeatures.getValue();
                ItemPropertyBuilder ipb = ItemPropertyBuilder.create(String.class).bean(bean).field(idColumn);
                if (lookup != null) {
                    ipb = ipb.lookup(lookup);
                }
                ZoeFXProperty property = ipb.build();
                return property;
            }
        };
        return callback;
    }
}

