/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.model.property;

import com.axiastudio.zoefx.core.beans.BeanAccess;
import com.axiastudio.zoefx.desktop.model.property.ZoeFXProperty;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import javafx.beans.property.ObjectPropertyBase;

public class ItemDateProperty<P>
extends ObjectPropertyBase
implements ZoeFXProperty {
    private BeanAccess<P> beanAccess;

    public ItemDateProperty(BeanAccess beanAccess) {
        this.beanAccess = beanAccess;
    }

    public Object getBean() {
        return this.beanAccess.getBean();
    }

    public String getName() {
        return this.beanAccess.getName();
    }

    public Object get() {
        Object value = this.beanAccess.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Instant instant = Instant.ofEpochMilli(((Date)value).getTime());
            LocalDate localDate = LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate();
            return localDate;
        }
        return null;
    }

    public void set(Object localDate) {
        if (localDate == null) {
            this.beanAccess.setValue(null);
            return;
        }
        Instant instant = ((LocalDate)localDate).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        Date date = Date.from(instant);
        this.beanAccess.setValue((Object)date);
    }

    @Override
    public void refresh() {
        this.fireValueChangedEvent();
    }
}

