/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.model.property;

import com.axiastudio.zoefx.core.beans.BeanAccess;
import com.axiastudio.zoefx.desktop.model.converters.BigDecimal2String;
import com.axiastudio.zoefx.desktop.model.converters.Date2String;
import com.axiastudio.zoefx.desktop.model.converters.String2BigDecimal;
import com.axiastudio.zoefx.desktop.model.converters.String2Double;
import com.axiastudio.zoefx.desktop.model.converters.String2Integer;
import com.axiastudio.zoefx.desktop.model.converters.String2Long;
import com.axiastudio.zoefx.desktop.model.property.ItemBooleanProperty;
import com.axiastudio.zoefx.desktop.model.property.ItemDateProperty;
import com.axiastudio.zoefx.desktop.model.property.ItemListProperty;
import com.axiastudio.zoefx.desktop.model.property.ItemObjectProperty;
import com.axiastudio.zoefx.desktop.model.property.ItemStringProperty;
import com.axiastudio.zoefx.desktop.model.property.ZoeFXProperty;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;

public class ItemPropertyBuilder<T> {
    private Object bean;
    private String name;
    private String lookup = null;
    private Class<? extends T> propertyClass;

    public static <T> ItemPropertyBuilder<T> create(Class<? extends T> klass) {
        ItemPropertyBuilder<T> itemPropertyBuilder = new ItemPropertyBuilder<T>();
        itemPropertyBuilder.propertyClass = klass;
        return itemPropertyBuilder;
    }

    public ItemPropertyBuilder bean(Object bean) {
        this.bean = bean;
        return this;
    }

    public ItemPropertyBuilder field(String name) {
        this.name = name;
        return this;
    }

    public ItemPropertyBuilder lookup(String lookup) {
        this.lookup = lookup;
        return this;
    }

    public ZoeFXProperty build() {
        BeanAccess beanAccess = new BeanAccess(this.bean, this.name);
        Class fieldType = beanAccess.getReturnType();
        if (fieldType == null || this.propertyClass == null) {
            return null;
        }
        if (String.class.isAssignableFrom(this.propertyClass)) {
            if (String.class.isAssignableFrom(fieldType)) {
                ItemStringProperty item = new ItemStringProperty(beanAccess);
                return item;
            }
            if (Integer.class.isAssignableFrom(fieldType)) {
                ItemStringProperty<Integer> item = new ItemStringProperty<Integer>(beanAccess);
                item.setToStringFunction(Object::toString);
                item.setFromStringFunction(new String2Integer());
                return item;
            }
            if (Long.class.isAssignableFrom(fieldType)) {
                ItemStringProperty<Long> item = new ItemStringProperty<Long>(beanAccess);
                item.setToStringFunction(Object::toString);
                item.setFromStringFunction(new String2Long());
                return item;
            }
            if (Double.class.isAssignableFrom(fieldType)) {
                ItemStringProperty<Double> item = new ItemStringProperty<Double>(beanAccess);
                item.setToStringFunction(Object::toString);
                item.setFromStringFunction(new String2Double());
                return item;
            }
            if (BigDecimal.class.isAssignableFrom(fieldType)) {
                ItemStringProperty<BigDecimal> item = new ItemStringProperty<BigDecimal>(beanAccess);
                item.setToStringFunction(new BigDecimal2String());
                item.setFromStringFunction(new String2BigDecimal());
                return item;
            }
            if (Date.class.isAssignableFrom(fieldType)) {
                ItemStringProperty<Date> item = new ItemStringProperty<Date>(beanAccess);
                item.setToStringFunction(new Date2String());
                return item;
            }
            if (Object.class.isAssignableFrom(fieldType)) {
                ItemStringProperty item = new ItemStringProperty(beanAccess);
                item.setToStringFunction(o -> {
                    if (this.lookup != null) {
                        BeanAccess ba = new BeanAccess(o, this.lookup);
                        return (String)ba.getValue();
                    }
                    return o.toString();
                });
                return item;
            }
        } else if (Boolean.class.isAssignableFrom(this.propertyClass)) {
            if (Boolean.class.isAssignableFrom(fieldType)) {
                ItemBooleanProperty item = new ItemBooleanProperty(beanAccess);
                return item;
            }
        } else if (Date.class.isAssignableFrom(this.propertyClass)) {
            if (Date.class.isAssignableFrom(fieldType)) {
                ItemDateProperty item = new ItemDateProperty(beanAccess);
                return item;
            }
        } else {
            if (Collection.class.isAssignableFrom(this.propertyClass)) {
                ItemListProperty item = new ItemListProperty(beanAccess);
                return item;
            }
            if (Object.class.isAssignableFrom(this.propertyClass)) {
                ItemObjectProperty item = new ItemObjectProperty(beanAccess);
                return item;
            }
        }
        return null;
    }
}

