/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.view;

import com.axiastudio.zoefx.core.IOC;
import com.axiastudio.zoefx.core.db.Database;
import com.axiastudio.zoefx.core.db.EntityListener;
import com.axiastudio.zoefx.core.db.Manager;
import com.axiastudio.zoefx.core.db.Permission;
import com.axiastudio.zoefx.desktop.controller.BaseController;
import com.axiastudio.zoefx.desktop.controller.Controller;
import com.axiastudio.zoefx.desktop.db.DataSet;
import com.axiastudio.zoefx.desktop.db.DataSetBuilder;
import com.axiastudio.zoefx.desktop.db.TimeMachine;
import com.axiastudio.zoefx.desktop.skins.Skins;
import com.axiastudio.zoefx.desktop.view.Behavior;
import com.axiastudio.zoefx.desktop.view.ZSceneMode;
import com.axiastudio.zoefx.desktop.view.ZToolBar;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.MenuBar;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.BuilderFactory;

public class ZSceneBuilder<E> {
    private Manager<E> manager = null;
    private EnumSet<Permission> permissions = null;
    private EntityListener<E> listener = null;
    private List<E> store = null;
    private Class entityClass = null;
    private String source = null;
    private URL fxmlUrl;
    private URL propertiesUrl = null;
    private String title;
    private BaseController controller = null;
    private Double width = null;
    private Double height = null;
    private ZSceneMode mode = ZSceneMode.WINDOW;

    public static ZSceneBuilder create() {
        return new ZSceneBuilder();
    }

    public static ZSceneBuilder create(Class<?> entityClass) {
        ZSceneBuilder builder = new ZSceneBuilder();
        builder.setEntityClass(entityClass);
        return builder;
    }

    public ZSceneBuilder properties(URL url) {
        this.propertiesUrl = url;
        return this;
    }

    public ZSceneBuilder permission(Permission permission) {
        if (this.permissions == null) {
            this.permissions = EnumSet.of(permission);
        } else if (!this.permissions.contains(permission)) {
            this.permissions.add(permission);
        }
        return this;
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    public ZSceneBuilder manager(Manager manager) {
        this.manager = manager;
        return this;
    }

    public ZSceneBuilder store(List<E> store) {
        this.store = store;
        return this;
    }

    public ZSceneBuilder title(String title) {
        this.title = title;
        return this;
    }

    public String getTitle() {
        if (this.title == null) {
            return this.fxmlUrl.getFile().substring(this.fxmlUrl.getFile().lastIndexOf("/") + 1, this.fxmlUrl.getFile().lastIndexOf("."));
        }
        return this.title;
    }

    public ZSceneBuilder url(URL url) {
        this.fxmlUrl = url;
        return this;
    }

    public ZSceneBuilder source(String source) {
        this.source = source;
        return this;
    }

    public ZSceneBuilder width(Integer width) {
        this.width = width.doubleValue();
        return this;
    }

    public ZSceneBuilder width(Double width) {
        this.width = width;
        return this;
    }

    public ZSceneBuilder height(Integer height) {
        this.height = height.doubleValue();
        return this;
    }

    public ZSceneBuilder height(Double height) {
        this.height = height;
        return this;
    }

    public ZSceneBuilder controller(BaseController controller) {
        this.controller = controller;
        return this;
    }

    public ZSceneBuilder mode(ZSceneMode mode) {
        this.mode = mode;
        return this;
    }

    public ZSceneBuilder<E> listener(EntityListener<E> listener) {
        this.listener = listener;
        return this;
    }

    public Scene build() {
        ResourceBundle bundle = ResourceBundle.getBundle("i18n");
        FXMLLoader loader = new FXMLLoader(this.fxmlUrl, bundle);
        loader.setResources(bundle);
        loader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
        if (this.controller == null) {
            this.controller = new Controller();
        }
        loader.setController((Object)this.controller);
        Parent root = null;
        try {
            if (this.source == null) {
                loader.setLocation(this.fxmlUrl);
                root = (Parent)loader.load();
            } else {
                root = (Parent)loader.load((InputStream)new ByteArrayInputStream(this.source.getBytes()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (root instanceof Region) {
            if (this.width == null) {
                this.width = ((Region)root).getPrefWidth();
            }
            if (this.height == null) {
                this.height = ((Region)root).getPrefHeight();
            }
        }
        Scene scene = new Scene(root, this.width.doubleValue(), this.height.doubleValue());
        Skins.getActiveSkin().getStyle().ifPresent(s -> scene.getStylesheets().add(s));
        this.controller.setScene(scene);
        if (this.controller instanceof Controller) {
            Controller controller = (Controller)this.controller;
            controller.setMode(this.mode);
            ZToolBar toolBar = new ZToolBar(bundle);
            if (root instanceof VBox) {
                if (((VBox)root).getChildren().get(0) instanceof MenuBar) {
                    ((VBox)root).getChildren().add(1, (Object)toolBar);
                } else {
                    ((VBox)root).getChildren().add(0, (Object)toolBar);
                }
            } else {
                ((Pane)root).getChildren().add((Object)toolBar);
            }
            toolBar.setController(controller);
            if (this.propertiesUrl != null) {
                try {
                    controller.setBehavior(new Behavior(this.propertiesUrl.openStream()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            TimeMachine timeMachine = new TimeMachine();
            controller.setTimeMachine(timeMachine);
            if (this.manager == null) {
                Database database = (Database)IOC.queryUtility(Database.class);
                this.manager = database.createManager(this.entityClass);
            }
            if (this.store == null) {
                this.store = this.manager.getAll();
            }
            DataSet dataset = DataSetBuilder.create(this.entityClass).store(this.store).manager(this.manager).build();
            dataset.addDataSetEventListener(toolBar);
            dataset.addDataSetEventListener(controller);
            if (this.listener != null) {
                dataset.setListener(this.listener);
            }
            controller.bindDataSet(dataset);
            if (this.permissions != null) {
                dataset.setCanSelect(this.permissions.contains(Permission.SELECT));
                dataset.setCanInsert(this.permissions.contains(Permission.INSERT));
                dataset.setCanUpdate(this.permissions.contains(Permission.UPDATE));
                dataset.setCanDelete(this.permissions.contains(Permission.DELETE));
            }
            toolBar.canSelectProperty().bind((ObservableValue)dataset.canSelectProperty());
            toolBar.canInsertProperty().bind((ObservableValue)dataset.canInsertProperty());
            toolBar.canUpdateProperty().bind((ObservableValue)dataset.canUpdateProperty());
            toolBar.canDeleteProperty().bind((ObservableValue)dataset.canDeleteProperty());
        }
        return scene;
    }
}

