/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.view;

import com.axiastudio.zoefx.desktop.controller.Controller;
import com.axiastudio.zoefx.desktop.events.DataSetEvent;
import com.axiastudio.zoefx.desktop.events.DataSetEventListener;
import com.axiastudio.zoefx.desktop.skins.Skins;
import com.axiastudio.zoefx.desktop.view.ZSceneMode;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;

public class ZToolBar
extends ToolBar
implements DataSetEventListener {
    private Controller controller;
    private Map<String, Button> buttons = new HashMap<String, Button>();
    private String[] buttonNames = new String[]{"first", "previous", "COUNTER", "next", "last", "add", "delete", "save", "cancel", "print", "refresh", "search", "info"};
    private Label counterLabel;
    private SimpleBooleanProperty isOnlyOne = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());
    private SimpleBooleanProperty isDirty = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());
    private SimpleBooleanProperty isBOF = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());
    private SimpleBooleanProperty isEOF = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());
    private SimpleBooleanProperty canSelect = new SimpleBooleanProperty(Boolean.TRUE.booleanValue());
    private SimpleBooleanProperty canInsert = new SimpleBooleanProperty(Boolean.TRUE.booleanValue());
    private SimpleBooleanProperty canUpdate = new SimpleBooleanProperty(Boolean.TRUE.booleanValue());
    private SimpleBooleanProperty canDelete = new SimpleBooleanProperty(Boolean.TRUE.booleanValue());

    public ZToolBar(ResourceBundle bundle) {
        this.setId("navigationBar");
        this.initNavBar(bundle);
    }

    private void initNavBar(ResourceBundle bundle) {
        for (String buttonName : this.buttonNames) {
            if (buttonName.equals("COUNTER")) {
                this.counterLabel = new Label();
                this.counterLabel.setMinWidth(80.0);
                this.counterLabel.setAlignment(Pos.BASELINE_CENTER);
                this.counterLabel.setId("counterNavLabel");
                this.counterLabel.setText("0/0");
                this.getItems().add((Object)this.counterLabel);
                continue;
            }
            Button button = new Button();
            button.setId(buttonName + "NavButton");
            if (Skins.getActiveSkin().noIcons().booleanValue()) {
                button.setMinWidth(70.0);
                button.setText(bundle.getString("toolbar." + buttonName + "_short"));
            }
            String tooltipText = bundle.getString("toolbar." + buttonName);
            button.setTooltip(new Tooltip(tooltipText));
            this.buttons.put(buttonName, button);
            this.getItems().add((Object)button);
        }
    }

    public boolean getCanSelectProperty() {
        return this.canSelect.get();
    }

    public SimpleBooleanProperty canSelectProperty() {
        return this.canSelect;
    }

    public boolean getCanInsert() {
        return this.canInsert.get();
    }

    public SimpleBooleanProperty canInsertProperty() {
        return this.canInsert;
    }

    public boolean getCanUpdate() {
        return this.canUpdate.get();
    }

    public SimpleBooleanProperty canUpdateProperty() {
        return this.canUpdate;
    }

    public boolean getCanDelete() {
        return this.canDelete.get();
    }

    public SimpleBooleanProperty canDeleteProperty() {
        return this.canDelete;
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.buttons.get("first").setOnAction(this.controller.handlerGoFirst);
        this.buttons.get("previous").setOnAction(this.controller.handlerGoPrevious);
        this.buttons.get("next").setOnAction(this.controller.handlerGoNext);
        this.buttons.get("last").setOnAction(this.controller.handlerGoLast);
        this.buttons.get("cancel").setOnAction(this.controller.handlerCancel);
        this.buttons.get("add").setOnAction(this.controller.handlerAdd);
        this.buttons.get("print").setOnAction(this.controller.handlerPrint);
        this.buttons.get("refresh").setOnAction(this.controller.handlerRefresh);
        this.buttons.get("search").setOnAction(this.controller.handlerSearch);
        this.buttons.get("info").setOnAction(this.controller.handlerInfo);
        this.buttons.get("first").disableProperty().bind((ObservableValue)this.isDirty.or((ObservableBooleanValue)this.isOnlyOne).or((ObservableBooleanValue)this.isBOF));
        this.buttons.get("previous").disableProperty().bind((ObservableValue)this.isDirty.or((ObservableBooleanValue)this.isOnlyOne).or((ObservableBooleanValue)this.isBOF));
        this.buttons.get("next").disableProperty().bind((ObservableValue)this.isDirty.or((ObservableBooleanValue)this.isOnlyOne).or((ObservableBooleanValue)this.isEOF));
        this.buttons.get("last").disableProperty().bind((ObservableValue)this.isDirty.or((ObservableBooleanValue)this.isOnlyOne).or((ObservableBooleanValue)this.isEOF));
        this.buttons.get("cancel").disableProperty().bind((ObservableValue)this.isDirty.not());
        this.buttons.get("save").disableProperty().bind((ObservableValue)this.isDirty.not().or((ObservableBooleanValue)this.canUpdateProperty().not()));
        this.buttons.get("search").disableProperty().bind((ObservableValue)this.canSelectProperty().not());
        if (controller.getMode().equals((Object)ZSceneMode.WINDOW)) {
            this.buttons.get("add").disableProperty().bind((ObservableValue)this.isDirty.or((ObservableBooleanValue)this.canInsertProperty().not()));
            this.buttons.get("delete").disableProperty().bind((ObservableValue)this.isDirty.or((ObservableBooleanValue)this.canDeleteProperty().not()));
            this.buttons.get("save").setOnAction(this.controller.handlerSave);
            this.buttons.get("delete").setOnAction(this.controller.handlerDelete);
        } else if (controller.getMode().equals((Object)ZSceneMode.DIALOG)) {
            this.buttons.get("add").setDisable(Boolean.TRUE.booleanValue());
            this.buttons.get("delete").setDisable(Boolean.TRUE.booleanValue());
            this.buttons.get("save").setId("acceptNavButton");
            this.buttons.get("save").setOnAction(this.controller.handlerConfirm);
        }
    }

    private void refresh() {
        if (this.controller == null) {
            return;
        }
        this.isOnlyOne.setValue(Boolean.valueOf(this.controller.getDataset().size() == 1));
        this.isDirty.setValue(this.controller.getDataset().isDirty());
        this.isBOF.setValue(Boolean.valueOf(this.controller.getDataset().getCurrentIndex() == 0));
        this.isEOF.setValue(Boolean.valueOf(this.controller.getDataset().getCurrentIndex() == this.controller.getDataset().size() - 1));
        String text = this.controller.getDataset().getCurrentIndex() + 1 + "/" + this.controller.getDataset().size();
        this.counterLabel.setText(text);
    }

    @Override
    public void dataSetEventHandler(DataSetEvent event) {
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "{0} event handled", event.getEventType().getName());
        if (event.getEventType().equals(DataSetEvent.INDEX_CHANGED)) {
            this.refresh();
        } else if (event.getEventType().equals(DataSetEvent.GET_DIRTY)) {
            this.refresh();
        } else if (event.getEventType().equals(DataSetEvent.COMMITED)) {
            this.refresh();
        } else if (event.getEventType().equals(DataSetEvent.STORE_CHANGED)) {
            this.refresh();
        } else if (event.getEventType().equals(DataSetEvent.REVERTED)) {
            this.refresh();
        } else if (event.getEventType().equals(DataSetEvent.DELETED)) {
            this.refresh();
        }
    }
}

