/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.view.msgbox;

import com.axiastudio.zoefx.desktop.skins.Skins;
import com.axiastudio.zoefx.desktop.view.msgbox.MsgBoxController;
import com.axiastudio.zoefx.desktop.view.msgbox.MsgBoxResponse;
import com.axiastudio.zoefx.desktop.view.msgbox.MsgBoxType;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.util.BuilderFactory;

public class MsgBoxBuilder {
    private String title = "";
    private String masthead = "";
    private String message = "";
    private String details = "";

    public static MsgBoxBuilder create() {
        return new MsgBoxBuilder();
    }

    public MsgBoxBuilder title(String title) {
        this.title = title;
        return this;
    }

    public MsgBoxBuilder masthead(String masthead) {
        this.masthead = masthead;
        return this;
    }

    public MsgBoxBuilder message(String message) {
        this.message = message;
        return this;
    }

    public MsgBoxBuilder details(String details) {
        this.details = details;
        return this;
    }

    public MsgBoxResponse showConfirm() {
        return this.showDialog(MsgBoxType.CONFIRM);
    }

    public MsgBoxResponse showInfo() {
        return this.showDialog(MsgBoxType.INFO);
    }

    private MsgBoxResponse showDialog(MsgBoxType type) {
        ResourceBundle bundle = ResourceBundle.getBundle("i18n");
        URL url = this.getClass().getResource("/fxml/msgbox.fxml");
        FXMLLoader loader = new FXMLLoader(url, bundle);
        loader.setResources(bundle);
        loader.setLocation(url);
        loader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
        MsgBoxController controller = new MsgBoxController();
        loader.setController((Object)controller);
        Parent root = null;
        try {
            root = (Parent)loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        controller.setMessage(this.message);
        controller.setMasthead(this.masthead);
        controller.setDetails(this.details);
        controller.config(type);
        Scene scene = new Scene(root);
        Skins.getActiveSkin().getStyle().ifPresent(s -> scene.getStylesheets().add(s));
        Stage stage = new Stage();
        stage.setTitle(this.title);
        stage.setScene(scene);
        stage.showAndWait();
        return controller.getResponse();
    }
}

