/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.view.msgbox;

import com.axiastudio.zoefx.desktop.view.msgbox.MsgBoxResponse;
import com.axiastudio.zoefx.desktop.view.msgbox.MsgBoxType;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class MsgBoxController
implements Initializable {
    private final int MAX_HEIGHT = 250;
    private final int MIN_HEIGHT = 350;
    @FXML
    private VBox vbox;
    @FXML
    private Label iconLabel;
    @FXML
    private Button cancelMsgBox;
    @FXML
    private Button okMsgBox;
    @FXML
    private Label messageLabel;
    @FXML
    private Label mastheadLabel;
    @FXML
    private TextArea detailsTextArea;
    @FXML
    private TitledPane detailsTitledPane;
    @FXML
    private Accordion detailsAccordion;
    public MsgBoxResponse response = MsgBoxResponse.CANCEL;

    public void initialize(URL location, ResourceBundle resources) {
        this.detailsAccordion.setVisible(Boolean.FALSE.booleanValue());
        this.detailsTitledPane.expandedProperty().addListener((observable, oldValue, newValue) -> {
            Stage stage = (Stage)this.messageLabel.getScene().getWindow();
            if (newValue.booleanValue()) {
                stage.setMinHeight(350.0);
                stage.setMaxHeight(350.0);
            } else {
                stage.setMinHeight(250.0);
                stage.setMaxHeight(250.0);
            }
        });
    }

    public void config(MsgBoxType type) {
        switch (type) {
            case CONFIRM: {
                break;
            }
            case INFO: {
                this.cancelMsgBox.setVisible(Boolean.FALSE.booleanValue());
                break;
            }
        }
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    public void setTitle(String title) {
        Stage stage = (Stage)this.messageLabel.getScene().getWindow();
        stage.setTitle(title);
    }

    public void setMasthead(String masthead) {
        this.mastheadLabel.setText(masthead);
    }

    public void setDetails(String details) {
        this.detailsTextArea.setText(details);
        this.detailsAccordion.setVisible(details.length() > 0);
    }

    public MsgBoxResponse getResponse() {
        return this.response;
    }

    @FXML
    void handlerOk(ActionEvent event) {
        this.response = MsgBoxResponse.OK;
        this.close();
    }

    @FXML
    void handlerCancel(ActionEvent event) {
        this.response = MsgBoxResponse.CANCEL;
        this.close();
    }

    private void close() {
        Stage stage = (Stage)this.messageLabel.getScene().getWindow();
        stage.close();
    }
}

