/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.view.report;

import com.axiastudio.zoefx.core.IOC;
import com.axiastudio.zoefx.core.report.ReportEngine;
import com.axiastudio.zoefx.core.report.ReportTemplate;
import com.axiastudio.zoefx.core.report.Reports;
import com.axiastudio.zoefx.desktop.controller.BaseController;
import com.axiastudio.zoefx.desktop.model.beans.LookupStringConverter;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

public class ReportController<T>
extends BaseController {
    @FXML
    private ChoiceBox<ReportTemplate> templates;
    @FXML
    private Button printButton;
    @FXML
    private Button exportButton;
    private Class entityClass;
    private List<T> store;

    public void initialize(URL location, ResourceBundle resources) {
        ReportEngine reportEngine = (ReportEngine)IOC.queryUtility(ReportEngine.class);
        this.printButton.setDisable(reportEngine.canPrint() == false);
        this.printButton.setText(resources.getString("report.print_button"));
        this.exportButton.setDisable(reportEngine.canExportToPdf() == false);
        this.exportButton.setText(resources.getString("report.export_to_pdf_button"));
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
        ObservableList choices = FXCollections.observableArrayList((Collection)Reports.getTemplates((Class)entityClass));
        this.templates.setConverter(new LookupStringConverter("title"));
        this.templates.setItems(choices);
        this.templates.setValue(choices.get(0));
    }

    public void setStore(List<T> store) {
        this.store = store;
    }

    @FXML
    void exportToPdf(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save to...");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PDF file", new String[]{"*.pdf"}));
        File file = fileChooser.showSaveDialog(null);
        ReportTemplate reportTemplate = (ReportTemplate)this.templates.getValue();
        ReportEngine reportEngine = (ReportEngine)IOC.queryUtility(ReportEngine.class);
        reportEngine.toPdf(reportTemplate, this.store, file);
        ((Stage)this.getScene().getWindow()).close();
    }

    @FXML
    void print(ActionEvent event) {
        ReportTemplate reportTemplate = (ReportTemplate)this.templates.getValue();
        ReportEngine reportEngine = (ReportEngine)IOC.queryUtility(ReportEngine.class);
        reportEngine.toPrinter(reportTemplate, this.store);
        ((Stage)this.getScene().getWindow()).close();
    }
}

