/*
 * Decompiled with CFR 0.152.
 */
package com.axiastudio.zoefx.desktop.view.search;

import com.axiastudio.zoefx.core.IOC;
import com.axiastudio.zoefx.core.beans.BeanClassAccess;
import com.axiastudio.zoefx.core.db.Database;
import com.axiastudio.zoefx.core.db.Manager;
import com.axiastudio.zoefx.desktop.db.DataSet;
import com.axiastudio.zoefx.desktop.db.DataSetBuilder;
import com.axiastudio.zoefx.desktop.model.beans.LookupStringConverter;
import com.axiastudio.zoefx.desktop.model.converters.String2BigDecimal;
import com.axiastudio.zoefx.desktop.model.property.CallbackBuilder;
import com.axiastudio.zoefx.desktop.view.Behavior;
import com.axiastudio.zoefx.desktop.view.Comparators;
import com.axiastudio.zoefx.desktop.view.search.Criterion;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;

public class SearchController<T>
implements Initializable {
    @FXML
    private TableView results;
    @FXML
    private Button searchSearchForm;
    @FXML
    private VBox filterbox;
    @FXML
    private Button applySearchForm;
    @FXML
    private TitledPane filters;
    private Class entityClass;
    private Behavior behavior;
    private Callback<List<T>, Boolean> callback = null;
    private List<Criterion> criteria = new ArrayList<Criterion>();

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.results.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.filters.setText(resourceBundle.getString("search.filters"));
        this.searchSearchForm.setText(resourceBundle.getString("search.search"));
        this.applySearchForm.setText(resourceBundle.getString("search.apply"));
    }

    public void setEntityClass(Class<? extends T> entityClass) {
        this.entityClass = entityClass;
    }

    public void setBehavior(Behavior behavior) {
        this.behavior = behavior;
    }

    public void setCallback(Callback<List<T>, Boolean> callback) {
        this.callback = callback;
    }

    public void setColumns(List<String> columns) {
        for (String property : columns) {
            TableColumn column = new TableColumn();
            column.setText(property);
            String lookup = null;
            if (this.behavior != null) {
                lookup = this.behavior.getProperties().getProperty(property + ".lookup");
            }
            Callback callback = CallbackBuilder.create().beanClass(this.entityClass).field(property).lookup(lookup).build();
            column.setCellValueFactory(callback);
            BeanClassAccess beanClassAccess = new BeanClassAccess(this.entityClass, property);
            if (beanClassAccess.getReturnType() == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Unable to set search column '" + property + "' (maybe wrong searchcolumns property?))");
                return;
            }
            if (Date.class.isAssignableFrom(beanClassAccess.getReturnType())) {
                column.setComparator(Comparator.nullsFirst(Comparators.DateComparator));
            }
            this.results.getColumns().add((Object)column);
        }
    }

    public void setCriteria(List<String> fields) {
        for (String property : fields) {
            TextField textField;
            HBox hBox = new HBox();
            hBox.setSpacing(10.0);
            Label label = new Label(property);
            label.setMinWidth(120.0);
            TextField criterionNode = null;
            BeanClassAccess beanClassAccess = new BeanClassAccess(this.entityClass, property);
            Class returnType = beanClassAccess.getReturnType();
            if (beanClassAccess.getReturnType() == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Unable to set search criteria '" + property + "' (maybe wrong searchcriteria property?))");
                return;
            }
            if (String.class.isAssignableFrom(beanClassAccess.getReturnType())) {
                textField = new TextField();
                textField.setMinWidth(200.0);
                textField.setId(property);
                criterionNode = textField;
                this.criteria.add(new Criterion(String.class, new Node[]{textField}));
            } else if (BigDecimal.class.isAssignableFrom(beanClassAccess.getReturnType())) {
                textField = new TextField();
                textField.setMinWidth(200.0);
                textField.setId(property);
                criterionNode = textField;
                this.criteria.add(new Criterion(BigDecimal.class, new Node[]{textField}));
            } else if (Boolean.class.isAssignableFrom(beanClassAccess.getReturnType())) {
                CheckBox checkBox = new CheckBox();
                checkBox.setAllowIndeterminate(true);
                checkBox.setIndeterminate(true);
                checkBox.setMinWidth(200.0);
                checkBox.setId(property);
                criterionNode = checkBox;
                this.criteria.add(new Criterion(Boolean.class, new Node[]{checkBox}));
            } else if (Date.class.isAssignableFrom(beanClassAccess.getReturnType())) {
                HBox dateHBox = new HBox();
                T[] fromDatePicker = new DatePicker();
                fromDatePicker.setId(property);
                DatePicker toDatePicker = new DatePicker();
                dateHBox.getChildren().addAll((Object[])new Node[]{fromDatePicker, toDatePicker});
                criterionNode = dateHBox;
                this.criteria.add(new Criterion(Date.class, new Node[]{fromDatePicker, toDatePicker}));
            } else if (Object.class.isAssignableFrom(beanClassAccess.getReturnType())) {
                String lookup;
                ArrayList superset = new ArrayList();
                if (returnType.isEnum()) {
                    for (Object obj : returnType.getEnumConstants()) {
                        superset.add(obj);
                    }
                } else {
                    Database database = (Database)IOC.queryUtility(Database.class);
                    if (database != null) {
                        Manager manager = database.createManager(returnType);
                        for (Object obj : manager.getAll()) {
                            superset.add(obj);
                        }
                    }
                }
                ChoiceBox choiceBox = new ChoiceBox();
                choiceBox.setId(property);
                if (this.behavior != null && (lookup = this.behavior.getProperties().getProperty(property + ".lookup")) != null) {
                    choiceBox.setConverter(new LookupStringConverter(lookup));
                }
                ObservableList choices = FXCollections.observableArrayList(superset);
                choiceBox.setItems(choices);
                criterionNode = choiceBox;
                this.criteria.add(new Criterion(Object.class, new Node[]{choiceBox}));
            }
            if (criterionNode == null) continue;
            hBox.getChildren().addAll((Object[])new Node[]{label, criterionNode});
            this.filterbox.getChildren().add((Object)hBox);
        }
    }

    @FXML
    private void search(ActionEvent event) {
        Database db = (Database)IOC.queryUtility(Database.class);
        Manager manager = db.createManager(this.entityClass);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < this.criteria.size(); ++i) {
            Object value;
            String fieldName;
            TextField criteriaField;
            Criterion criterion = this.criteria.get(i);
            if (criterion.getCriterionClass() == String.class) {
                criteriaField = (TextField)criterion.getNodes().get(0);
                fieldName = criteriaField.getId();
                value = criteriaField.getText();
                if (((String)value).length() <= 0) continue;
                map.put(fieldName, value);
                continue;
            }
            if (criterion.getCriterionClass() == Object.class) {
                ChoiceBox choiceBox = (ChoiceBox)criterion.getNodes().get(0);
                fieldName = choiceBox.getId();
                value = choiceBox.getSelectionModel().getSelectedItem();
                map.put(fieldName, value);
                continue;
            }
            if (criterion.getCriterionClass() == Boolean.class) {
                criteriaField = (CheckBox)criterion.getNodes().get(0);
                fieldName = criteriaField.getId();
                if (criteriaField.isIndeterminate() || (value = Boolean.valueOf(criteriaField.isSelected())) == null) continue;
                map.put(fieldName, value);
                continue;
            }
            if (criterion.getCriterionClass() == BigDecimal.class) {
                criteriaField = (TextField)criterion.getNodes().get(0);
                fieldName = criteriaField.getId();
                value = new String2BigDecimal().call(criteriaField.getText());
                if (value == null) continue;
                map.put(fieldName, value);
                continue;
            }
            if (criterion.getCriterionClass() != Date.class) continue;
            DatePicker firstDateNode = (DatePicker)criterion.getNodes().get(0);
            fieldName = firstDateNode.getId();
            DatePicker secondDateNode = (DatePicker)criterion.getNodes().get(1);
            ArrayList<Date> value2 = new ArrayList<Date>();
            LocalDate fromLocalDate = (LocalDate)firstDateNode.getValue();
            if (fromLocalDate == null) continue;
            value2.add(this.localDateToDate(fromLocalDate));
            LocalDate toLocalDate = (LocalDate)secondDateNode.getValue();
            if (toLocalDate != null) {
                value2.add(this.localDateToDate(toLocalDate));
            } else {
                value2.add(this.localDateToDate(fromLocalDate));
            }
            map.put(fieldName, value2);
        }
        DataSet dataSet = map.keySet().size() > 0 ? DataSetBuilder.create(this.entityClass).store(manager.query(map)).manager(manager).build() : DataSetBuilder.create(this.entityClass).store(manager.getAll()).manager(manager).build();
        ObservableList observableList = dataSet.size() > 0 ? FXCollections.observableArrayList(dataSet.getStore()) : FXCollections.observableArrayList(new ArrayList());
        this.results.setItems(observableList);
    }

    @FXML
    private void apply(ActionEvent event) {
        ObservableList items = this.results.getSelectionModel().getSelectedItems();
        this.callback.call((Object)items);
        Stage stage = (Stage)this.filterbox.getScene().getWindow();
        stage.close();
    }

    private Date localDateToDate(LocalDate localDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(localDate.getYear(), localDate.getMonthValue() - 1, localDate.getDayOfMonth());
        Date date = calendar.getTime();
        return date;
    }
}

