/*
 * Decompiled with CFR 0.152.
 */
package com.axokoi.discid;

import com.axokoi.discid.LibDiscId;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMBDiscId {
    private static Log log = LogFactory.getLog(JMBDiscId.class);
    private static LibDiscId libDiscId = null;
    private Pointer disc = null;

    public synchronized boolean init(String path) {
        if (!new File(path).exists()) {
            log.fatal((Object)("File: " + path + " does not exist"));
        } else {
            if (libDiscId == null) {
                try {
                    libDiscId = (LibDiscId)Native.loadLibrary((String)path, LibDiscId.class);
                }
                catch (Throwable ex) {
                    log.fatal((Object)"Check you running are the correct library for your architecture: 64 or 32 bit", ex);
                }
            }
            if (libDiscId != null && this.disc == null) {
                this.disc = this.disc = libDiscId.discid_new();
            }
        }
        return libDiscId != null;
    }

    public String getDiscId(String drive) {
        String ret = null;
        boolean success = libDiscId.discid_read(this.disc, drive);
        if (!success) {
            log.fatal((Object)libDiscId.discid_get_error_msg(this.disc).getString(0L));
        } else {
            ret = libDiscId.discid_get_id(this.disc).getString(0L);
        }
        return ret;
    }

    public String getFreeDBId(String drive) {
        String ret = null;
        boolean success = libDiscId.discid_read(this.disc, drive);
        if (!success) {
            log.fatal((Object)libDiscId.discid_get_error_msg(this.disc).getString(0L));
        } else {
            ret = libDiscId.discid_get_freedb_id(this.disc).getString(0L);
        }
        return ret;
    }

    public String getSubmissionUrl(String drive) {
        String ret = null;
        boolean success = libDiscId.discid_read(this.disc, drive);
        if (!success) {
            log.fatal((Object)libDiscId.discid_get_error_msg(this.disc).getString(0L));
        } else {
            ret = libDiscId.discid_get_submission_url(this.disc).getString(0L);
        }
        return ret;
    }

    public String getDiscIdLookupUrl(String drive) {
        String ret = null;
        String discId = this.getDiscId(drive);
        String toc = this.getSubmissionUrl(drive);
        if (discId != null && toc != null) {
            toc = toc.substring(toc.indexOf(38));
            ret = "http://www.musicbrainz.org/ws/2/discid/" + discId + "?" + toc;
        }
        return ret;
    }

    public String getToC(String drive) {
        boolean success = libDiscId.discid_read(this.disc, drive);
        if (!success) {
            log.fatal((Object)libDiscId.discid_get_error_msg(this.disc).getString(0L));
            return "";
        }
        return libDiscId.discid_get_toc_string(this.disc);
    }

    protected void finalize() {
        if (null != this.disc) {
            libDiscId.discid_free(this.disc);
            this.disc = null;
        }
    }
}

